/*
 * Decompiled with CFR 0.152.
 */
package org.java.plugin.tools.ant;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import org.apache.tools.ant.BuildException;
import org.java.plugin.tools.ant.BaseJpfTask;
import org.java.plugin.tools.docgen.DocGenerator;

public final class DocTask
extends BaseJpfTask {
    private File destDir;
    private File overviewFile;
    private String encoding;
    private String docEncoding;
    private String templatesPath;
    private File stylesheetFile;

    public void setDestDir(File aDestDir) {
        this.destDir = aDestDir;
    }

    public void setOverview(File anOverviewFile) {
        this.overviewFile = anOverviewFile;
    }

    public void setEncoding(String anEncoding) {
        this.encoding = anEncoding;
    }

    public void setDocEncoding(String anEncoding) {
        this.docEncoding = anEncoding;
    }

    public void setStylesheetFile(File aStylesheetFile) {
        this.stylesheetFile = aStylesheetFile;
    }

    public void setTemplates(String aTemplatesPath) {
        this.templatesPath = aTemplatesPath;
    }

    public void execute() {
        if (this.destDir == null) {
            throw new BuildException("destdir attribute must be set!", this.getLocation());
        }
        if (!this.destDir.exists() && !this.destDir.mkdirs()) {
            throw new BuildException("can't make " + this.destDir + " folder", this.getLocation());
        }
        if (this.destDir.list().length != 0) {
            throw new BuildException("directory " + this.destDir + " is not empty", this.getLocation());
        }
        this.initRegistry(true);
        try {
            DocGenerator docGen = this.templatesPath != null ? new DocGenerator(this.getRegistry(), this.getPathResolver(), this.templatesPath, this.encoding) : new DocGenerator(this.getRegistry(), this.getPathResolver());
            if (this.overviewFile != null) {
                docGen.setDocumentationOverview(this.getFileContent(this.overviewFile));
            }
            if (this.stylesheetFile != null) {
                docGen.setStylesheet(this.getFileContent(this.stylesheetFile));
            }
            if (this.docEncoding != null) {
                docGen.setOutputEncoding(this.docEncoding);
            }
            docGen.generate(this.destDir);
            this.log("Documentation generated to folder " + this.destDir);
        }
        catch (Exception e) {
            throw new BuildException((Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getFileContent(File file) throws IOException {
        BufferedReader reader = this.encoding != null ? new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file), this.encoding)) : new BufferedReader(new InputStreamReader(new FileInputStream(file)));
        try {
            int len;
            StringBuilder result = new StringBuilder();
            char[] buf = new char[256];
            while ((len = reader.read(buf)) != -1) {
                result.append(buf, 0, len);
            }
            String string = result.toString();
            return string;
        }
        finally {
            ((Reader)reader).close();
        }
    }
}

