/*
 * Decompiled with CFR 0.152.
 */
package jdd.util.pool;

import jdd.util.JDDConsole;
import jdd.util.pool.ObjectCreator;

public class ObjectPool {
    private static final int DEFAULT_SIZE = 8;
    private static final int MAX_SIZE = 4096;
    private Object[] stack;
    private int curr;
    private ObjectCreator creator;
    private long ins;
    private long outs;
    private long losts;

    private void fillup() {
        while (this.curr < 8) {
            this.stack[this.curr++] = this.creator.createNew();
        }
    }

    private void resize() {
        int n = Math.min(this.stack.length * 2 + 1, 4096);
        Object[] objectArray = new Object[n];
        for (int i = 0; i < this.curr; ++i) {
            objectArray[i] = this.stack[i];
        }
        this.stack = objectArray;
    }

    public ObjectPool(ObjectCreator objectCreator) {
        this.creator = objectCreator;
        this.stack = new Object[8];
        this.curr = 0;
        this.ins = 0L;
        this.outs = 0L;
        this.losts = 0L;
        this.fillup();
    }

    public void clear() {
        for (int i = 0; i < this.stack.length; ++i) {
            this.stack[i] = null;
        }
        this.curr = 0;
    }

    public Object get() {
        ++this.outs;
        if (this.curr == 0) {
            this.fillup();
        }
        return this.stack[--this.curr];
    }

    public void put(Object object) {
        if (this.curr == this.stack.length) {
            if (this.curr == 4096) {
                ++this.losts;
                return;
            }
            this.resize();
        }
        this.stack[this.curr++] = object;
        ++this.ins;
    }

    public int getCapacity() {
        return this.stack.length;
    }

    public int getSize() {
        return this.curr;
    }

    public void showStats() {
        JDDConsole.out.println("Object pool statistics: capacity " + this.getCapacity() + ", size " + this.getSize());
        JDDConsole.out.println("   Recorded " + this.ins + " insert, " + this.outs + " gets, " + this.losts + " objects lost.");
    }
}

