/*
 * Decompiled with CFR 0.152.
 */
package org.java.plugin.tools.ant;

import java.io.File;
import java.io.IOException;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;
import org.java.plugin.ObjectFactory;
import org.java.plugin.registry.ManifestProcessingException;
import org.java.plugin.tools.PluginArchiver;
import org.java.plugin.util.IoUtil;

public final class UnpackTask
extends Task {
    private File destDir;
    private File srcFile;

    public void setSrcFile(File aSrcFile) {
        this.srcFile = aSrcFile;
    }

    public void setDestDir(File aDestFolder) {
        this.destDir = aDestFolder;
    }

    public void execute() {
        if (this.srcFile == null) {
            throw new BuildException("srcfile attribute must be set!", this.getLocation());
        }
        if (this.destDir == null) {
            throw new BuildException("destdir attribute must be set!", this.getLocation());
        }
        try {
            PluginArchiver.unpack(IoUtil.file2url(this.srcFile), ObjectFactory.newInstance().createRegistry(), this.destDir);
            this.log("Plug-ins archive unpacked to folder " + this.destDir);
        }
        catch (IOException ioe) {
            throw new BuildException((Throwable)ioe);
        }
        catch (ManifestProcessingException mpe) {
            throw new BuildException((Throwable)mpe);
        }
        catch (ClassNotFoundException cnfe) {
            throw new BuildException((Throwable)cnfe);
        }
    }
}

