/*
 * Decompiled with CFR 0.152.
 */
package org.java.plugin.tools.mocks;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import org.java.plugin.registry.Extension;
import org.java.plugin.registry.ExtensionMultiplicity;
import org.java.plugin.registry.ExtensionPoint;
import org.java.plugin.tools.mocks.MockPluginElement;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MockExtensionPoint
extends MockPluginElement<ExtensionPoint>
implements ExtensionPoint {
    private ExtensionMultiplicity multiplicity;
    private String parentExtensionPointId;
    private String parentPluginId;
    private boolean isValid = true;
    private LinkedList<Extension> availableExtensions = new LinkedList();
    private LinkedList<Extension> connectedExtensions = new LinkedList();
    private LinkedList<ExtensionPoint> descendants = new LinkedList();
    private LinkedList<ExtensionPoint.ParameterDefinition> parameterDefinitions = new LinkedList();
    private HashSet<String> predecessors = new HashSet();

    @Override
    public Extension getAvailableExtension(String uniqueId) {
        for (Extension ext : this.availableExtensions) {
            if (!ext.getUniqueId().equals(uniqueId)) continue;
            return ext;
        }
        throw new IllegalArgumentException("extension UID " + uniqueId + " not available");
    }

    @Override
    public Collection<Extension> getAvailableExtensions() {
        return Collections.unmodifiableCollection(this.availableExtensions);
    }

    @Override
    public Extension getConnectedExtension(String uniqueId) {
        for (Extension ext : this.connectedExtensions) {
            if (!ext.getUniqueId().equals(uniqueId)) continue;
            return ext;
        }
        throw new IllegalArgumentException("extension UID " + uniqueId + " not connected");
    }

    @Override
    public Collection<Extension> getConnectedExtensions() {
        return Collections.unmodifiableCollection(this.connectedExtensions);
    }

    public MockExtensionPoint addExtension(Extension extension, boolean isConnected) {
        this.availableExtensions.add(extension);
        if (isConnected) {
            this.connectedExtensions.add(extension);
        }
        return this;
    }

    @Override
    public Collection<ExtensionPoint> getDescendants() {
        return Collections.unmodifiableCollection(this.descendants);
    }

    public MockExtensionPoint addParameter(ExtensionPoint extensionPoint) {
        this.descendants.add(extensionPoint);
        return this;
    }

    @Override
    public ExtensionMultiplicity getMultiplicity() {
        return this.multiplicity;
    }

    public MockExtensionPoint setMultiplicity(ExtensionMultiplicity value) {
        this.multiplicity = value;
        return this;
    }

    @Override
    public ExtensionPoint.ParameterDefinition getParameterDefinition(String id) {
        for (ExtensionPoint.ParameterDefinition paramDef : this.parameterDefinitions) {
            if (!paramDef.getId().equals(id)) continue;
            return paramDef;
        }
        throw new IllegalArgumentException("unknown parameter definition ID " + id);
    }

    @Override
    public Collection<ExtensionPoint.ParameterDefinition> getParameterDefinitions() {
        return Collections.unmodifiableCollection(this.parameterDefinitions);
    }

    public MockExtensionPoint addParameterDefinition(ExtensionPoint.ParameterDefinition parameterDefinition) {
        this.parameterDefinitions.add(parameterDefinition);
        return this;
    }

    @Override
    public String getParentExtensionPointId() {
        return this.parentExtensionPointId;
    }

    public MockExtensionPoint setParentExtensionPoint(String pluginId, String extensionPointId) {
        this.parentPluginId = pluginId;
        this.parentExtensionPointId = extensionPointId;
        this.predecessors.add(pluginId + '@' + extensionPointId);
        return this;
    }

    @Override
    public String getParentPluginId() {
        return this.parentPluginId;
    }

    @Override
    public boolean isExtensionAvailable(String uniqueId) {
        for (Extension ext : this.availableExtensions) {
            if (!ext.getUniqueId().equals(uniqueId)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isExtensionConnected(String uniqueId) {
        for (Extension ext : this.connectedExtensions) {
            if (!ext.getUniqueId().equals(uniqueId)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isSuccessorOf(ExtensionPoint extensionPoint) {
        return this.predecessors.contains(extensionPoint.getUniqueId());
    }

    public MockExtensionPoint addPredecessors(String pluginId, String extensionPointId) {
        this.predecessors.add(pluginId + '@' + extensionPointId);
        return this;
    }

    @Override
    public boolean isValid() {
        return this.isValid;
    }

    public MockExtensionPoint setValid(boolean value) {
        this.isValid = value;
        return this;
    }

    @Override
    public String getUniqueId() {
        return this.getDeclaringPluginDescriptor().getId() + '@' + this.getId();
    }
}

