/*
 * Decompiled with CFR 0.152.
 */
package de.tum.in.jbdd;

import de.tum.in.jbdd.Bdd;
import de.tum.in.jbdd.BddImpl;
import java.util.BitSet;
import java.util.concurrent.Callable;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.function.BiConsumer;
import java.util.function.Consumer;

public final class SynchronizedBdd
implements Bdd {
    private final BddImpl delegate;
    private final Lock readLock;
    private final Lock writeLock;

    SynchronizedBdd(BddImpl delegate, ReadWriteLock lock) {
        this.delegate = delegate;
        this.writeLock = lock.writeLock();
        this.readLock = lock.readLock();
    }

    @Override
    public int and(int node1, int node2) {
        this.writeLock.lock();
        int result = this.delegate.and(node1, node2);
        this.writeLock.unlock();
        return result;
    }

    @Override
    public int compose(int node, int[] variableNodes) {
        this.writeLock.lock();
        int result = this.delegate.compose(node, variableNodes);
        this.writeLock.unlock();
        return result;
    }

    @Override
    public int consume(int result, int inputNode1, int inputNode2) {
        this.writeLock.lock();
        int consumed = this.delegate.consume(result, inputNode1, inputNode2);
        this.writeLock.unlock();
        return consumed;
    }

    @Override
    public double countSatisfyingAssignments(int node) {
        this.readLock.lock();
        double result = this.delegate.countSatisfyingAssignments(node);
        this.readLock.unlock();
        return result;
    }

    @Override
    public int createVariable() {
        this.writeLock.lock();
        int result = this.delegate.createVariable();
        this.writeLock.unlock();
        return result;
    }

    @Override
    public int[] createVariables(int count) {
        this.writeLock.lock();
        int[] result = this.delegate.createVariables(count);
        this.writeLock.unlock();
        return result;
    }

    @Override
    public int cube(BitSet cubeVariables) {
        this.writeLock.lock();
        int result = this.delegate.cube(cubeVariables);
        this.writeLock.unlock();
        return result;
    }

    @Override
    public int dereference(int node) {
        this.writeLock.lock();
        int result = this.delegate.dereference(node);
        this.writeLock.unlock();
        return result;
    }

    @Override
    public int equivalence(int node1, int node2) {
        this.writeLock.lock();
        int result = this.delegate.equivalence(node1, node2);
        this.writeLock.unlock();
        return result;
    }

    @Override
    public boolean evaluate(int node, BitSet assignment) {
        this.readLock.lock();
        boolean result = this.delegate.evaluate(node, assignment);
        this.readLock.unlock();
        return result;
    }

    @Override
    public int exists(int node, BitSet quantifiedVariables) {
        this.writeLock.lock();
        int result = this.delegate.exists(node, quantifiedVariables);
        this.writeLock.unlock();
        return result;
    }

    @Override
    public void forEachMinimalSolution(int node, Consumer<BitSet> action) {
        this.readLock.lock();
        this.delegate.forEachMinimalSolution(node, action);
        this.readLock.unlock();
    }

    @Override
    public void forEachMinimalSolution(int node, BiConsumer<BitSet, BitSet> action) {
        this.readLock.lock();
        this.delegate.forEachMinimalSolution(node, action);
        this.readLock.unlock();
    }

    @Override
    public void forEachNonEmptyPath(int node, int highestVariable, BiConsumer<BitSet, BitSet> action) {
        this.readLock.lock();
        this.delegate.forEachNonEmptyPath(node, highestVariable, action);
        this.readLock.unlock();
    }

    @Override
    public int getFalseNode() {
        return this.delegate.getFalseNode();
    }

    @Override
    public int getHigh(int node) {
        this.readLock.lock();
        int result = this.delegate.getHigh(node);
        this.readLock.unlock();
        return result;
    }

    @Override
    public int getLow(int node) {
        this.readLock.lock();
        int result = this.delegate.getLow(node);
        this.readLock.unlock();
        return result;
    }

    @Override
    public BitSet getSatisfyingAssignment(int node) {
        this.readLock.lock();
        BitSet satisfyingAssignment = this.delegate.getSatisfyingAssignment(node);
        this.readLock.unlock();
        return satisfyingAssignment;
    }

    @Override
    public int getTrueNode() {
        return this.delegate.getTrueNode();
    }

    @Override
    public int getVariable(int node) {
        this.readLock.lock();
        int result = this.delegate.getVariable(node);
        this.readLock.unlock();
        return result;
    }

    @Override
    public int getVariableNode(int variableNumber) {
        this.readLock.lock();
        int result = this.delegate.getVariableNode(variableNumber);
        this.readLock.unlock();
        return result;
    }

    @Override
    public int ifThenElse(int ifNode, int thenNode, int elseNode) {
        this.writeLock.lock();
        int result = this.delegate.ifThenElse(ifNode, thenNode, elseNode);
        this.writeLock.unlock();
        return result;
    }

    @Override
    public int implication(int node1, int node2) {
        this.writeLock.lock();
        int result = this.delegate.implication(node1, node2);
        this.writeLock.unlock();
        return result;
    }

    @Override
    public boolean implies(int node1, int node2) {
        this.writeLock.lock();
        boolean result = this.delegate.implies(node1, node2);
        this.writeLock.unlock();
        return result;
    }

    @Override
    public boolean isNodeRoot(int node) {
        return this.delegate.isNodeRoot(node);
    }

    @Override
    public boolean isVariable(int node) {
        this.readLock.lock();
        boolean result = this.delegate.isVariable(node);
        this.readLock.unlock();
        return result;
    }

    @Override
    public boolean isVariableNegated(int node) {
        this.readLock.lock();
        boolean result = this.delegate.isVariableNegated(node);
        this.readLock.unlock();
        return result;
    }

    @Override
    public boolean isVariableOrNegated(int node) {
        this.readLock.lock();
        boolean result = this.delegate.isVariableOrNegated(node);
        this.readLock.unlock();
        return result;
    }

    @Override
    public int not(int node) {
        this.writeLock.lock();
        int result = this.delegate.not(node);
        this.writeLock.unlock();
        return result;
    }

    @Override
    public int notAnd(int node1, int node2) {
        this.writeLock.lock();
        int result = this.delegate.notAnd(node1, node2);
        this.writeLock.unlock();
        return result;
    }

    @Override
    public int numberOfVariables() {
        this.readLock.lock();
        int result = this.delegate.numberOfVariables();
        this.readLock.unlock();
        return result;
    }

    @Override
    public int or(int node1, int node2) {
        this.writeLock.lock();
        int result = this.delegate.or(node1, node2);
        this.writeLock.unlock();
        return result;
    }

    public void readLock() {
        this.readLock.lock();
    }

    public <V> V readLocked(Callable<V> action) throws Exception {
        this.readLock.lock();
        try {
            V v = action.call();
            return v;
        }
        finally {
            this.readLock.unlock();
        }
    }

    public void readLocked(Runnable action) {
        this.readLock.lock();
        try {
            action.run();
        }
        finally {
            this.readLock.unlock();
        }
    }

    public void readUnlock() {
        this.readLock.unlock();
    }

    @Override
    public int reference(int node) {
        this.writeLock.lock();
        int result = this.delegate.reference(node);
        this.writeLock.unlock();
        return result;
    }

    @Override
    public int getReferenceCount(int node) {
        this.readLock.lock();
        int referenceCount = this.delegate.getReferenceCount(node);
        this.readLock.unlock();
        return referenceCount;
    }

    @Override
    public int restrict(int node, BitSet restrictedVariables, BitSet restrictedVariableValues) {
        this.writeLock.lock();
        int result = this.delegate.restrict(node, restrictedVariables, restrictedVariableValues);
        this.writeLock.unlock();
        return result;
    }

    @Override
    public BitSet support(int node) {
        this.writeLock.lock();
        BitSet result = this.delegate.support(node);
        this.writeLock.unlock();
        return result;
    }

    @Override
    public BitSet support(int node, int highestVariable) {
        this.writeLock.lock();
        BitSet result = this.delegate.support(node, highestVariable);
        this.writeLock.unlock();
        return result;
    }

    @Override
    public void support(int node, BitSet bitSet) {
        this.writeLock.lock();
        this.delegate.support(node, bitSet);
        this.writeLock.unlock();
    }

    @Override
    public void support(int node, BitSet bitSet, int highestVariable) {
        this.writeLock.lock();
        this.delegate.support(node, bitSet, highestVariable);
        this.writeLock.unlock();
    }

    @Override
    public int updateWith(int result, int inputNode) {
        this.writeLock.lock();
        int updated = this.delegate.updateWith(result, inputNode);
        this.writeLock.unlock();
        return updated;
    }

    public void writeLock() {
        this.writeLock.lock();
    }

    public <V> V writeLocked(Callable<V> action) throws Exception {
        this.writeLock.lock();
        try {
            V v = action.call();
            return v;
        }
        finally {
            this.writeLock.unlock();
        }
    }

    public void writeLocked(Runnable action) {
        this.writeLock.lock();
        try {
            action.run();
        }
        finally {
            this.writeLock.unlock();
        }
    }

    public void writeUnlock() {
        this.writeLock.unlock();
    }

    @Override
    public int xor(int node1, int node2) {
        this.writeLock.lock();
        int result = this.delegate.xor(node1, node2);
        this.writeLock.unlock();
        return result;
    }
}

