/*
 * Decompiled with CFR 0.152.
 */
package owl.automaton;

import com.google.common.base.Preconditions;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntList;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.PrimitiveIterator;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import owl.automaton.Automaton;
import owl.automaton.AutomatonFactory;
import owl.automaton.AutomatonUtil;
import owl.automaton.acceptance.AllAcceptance;
import owl.automaton.acceptance.BuchiAcceptance;
import owl.automaton.acceptance.CoBuchiAcceptance;
import owl.automaton.acceptance.GeneralizedBuchiAcceptance;
import owl.automaton.acceptance.GeneralizedRabinAcceptance;
import owl.automaton.acceptance.OmegaAcceptance;
import owl.automaton.acceptance.RabinAcceptance;
import owl.automaton.edge.Edge;
import owl.factories.ValuationSetFactory;

public final class AutomatonOperations {
    private AutomatonOperations() {
    }

    private static <S> boolean isSublist(List<S> subList, List<S> list) {
        return subList.size() <= list.size() && subList.equals(list.subList(0, subList.size()));
    }

    private static ValuationSetFactory sharedAlphabet(Stream<ValuationSetFactory> factories) {
        Iterator iterator = factories.iterator();
        ValuationSetFactory factory = (ValuationSetFactory)iterator.next();
        while (iterator.hasNext()) {
            ValuationSetFactory otherFactory = (ValuationSetFactory)iterator.next();
            if (AutomatonOperations.isSublist(factory.alphabet(), otherFactory.alphabet())) {
                factory = otherFactory;
                continue;
            }
            if (AutomatonOperations.isSublist(otherFactory.alphabet(), factory.alphabet())) continue;
            throw new IllegalArgumentException("Could not find shared alphabet.");
        }
        return factory;
    }

    public static <S> Automaton<List<S>, OmegaAcceptance> intersection(List<Automaton<S, ? extends OmegaAcceptance>> automata) {
        Preconditions.checkArgument((!automata.isEmpty() ? 1 : 0) != 0, (Object)"No automaton was passed.");
        ListAutomatonBuilder builder = new ListAutomatonBuilder(false, true);
        int offset = 1;
        for (Automaton<S, OmegaAcceptance> automaton : automata) {
            Preconditions.checkArgument((boolean)automaton.is(Automaton.Property.DETERMINISTIC), (Object)"Only deterministic automata supported");
            if (automaton.acceptance() instanceof AllAcceptance) {
                builder.all.add(AutomatonUtil.cast(automaton, AllAcceptance.class));
                continue;
            }
            if (automaton.acceptance() instanceof CoBuchiAcceptance) {
                builder.coBuchi.add(AutomatonUtil.cast(automaton, CoBuchiAcceptance.class));
                continue;
            }
            if (automaton.acceptance() instanceof GeneralizedBuchiAcceptance) {
                builder.buchi.add(AutomatonUtil.cast(automaton, GeneralizedBuchiAcceptance.class));
                builder.acceptanceRemapping.add(offset);
                offset += automaton.acceptance().acceptanceSets();
                continue;
            }
            throw new IllegalArgumentException("Unsupported Acceptance Type " + automaton.acceptance());
        }
        OmegaAcceptance acceptance = builder.buchi.isEmpty() ? CoBuchiAcceptance.INSTANCE : (builder.coBuchi.isEmpty() ? GeneralizedBuchiAcceptance.of(offset - 1) : (offset < 2 ? RabinAcceptance.of(GeneralizedRabinAcceptance.RabinPair.of(0)) : GeneralizedRabinAcceptance.of(GeneralizedRabinAcceptance.RabinPair.ofGeneralized(0, offset - 1))));
        ValuationSetFactory factory = AutomatonOperations.sharedAlphabet(automata.stream().map(Automaton::factory));
        return AutomatonFactory.create(factory, builder.init(), acceptance, builder::successor);
    }

    public static <S> Automaton<List<S>, BuchiAcceptance> union(List<Automaton<S, BuchiAcceptance>> automata) {
        Preconditions.checkArgument((!automata.isEmpty() ? 1 : 0) != 0, (Object)"No automaton was passed.");
        assert (automata.stream().allMatch(x -> x.is(Automaton.Property.DETERMINISTIC)));
        ListAutomatonBuilder builder = new ListAutomatonBuilder(true, false);
        ValuationSetFactory factory = AutomatonOperations.sharedAlphabet(automata.stream().map(Automaton::factory));
        builder.buchi.addAll(automata);
        return AutomatonFactory.create(factory, builder.init(), BuchiAcceptance.INSTANCE, builder::successor);
    }

    private static final class ListAutomatonBuilder<S> {
        final IntList acceptanceRemapping = new IntArrayList();
        final List<Automaton<S, AllAcceptance>> all = new ArrayList<Automaton<S, AllAcceptance>>();
        final List<Automaton<S, ? extends GeneralizedBuchiAcceptance>> buchi = new ArrayList<Automaton<S, ? extends GeneralizedBuchiAcceptance>>();
        final List<Automaton<S, CoBuchiAcceptance>> coBuchi = new ArrayList<Automaton<S, CoBuchiAcceptance>>();
        final boolean collapseBuchi;
        final boolean fastNull;

        ListAutomatonBuilder(boolean collapseBuchi, boolean fastNull) {
            this.collapseBuchi = collapseBuchi;
            this.fastNull = fastNull;
        }

        Automaton<S, ?> getAutomaton(int i) {
            int index = i;
            if (index < this.all.size()) {
                return this.all.get(index);
            }
            if ((index -= this.all.size()) < this.coBuchi.size()) {
                return this.coBuchi.get(index);
            }
            return this.buchi.get(index -= this.coBuchi.size());
        }

        int getOffset(int i) {
            int index = i;
            if (index < this.all.size()) {
                return -1;
            }
            if ((index -= this.all.size()) < this.coBuchi.size()) {
                return 0;
            }
            return this.acceptanceRemapping.getInt(index -= this.coBuchi.size());
        }

        List<S> init() {
            return Stream.of(this.all, this.coBuchi, this.buchi).flatMap(Collection::stream).map(Automaton::onlyInitialState).collect(Collectors.toUnmodifiableList());
        }

        @Nullable
        Edge<List<S>> successor(List<S> list, BitSet valuation) {
            ArrayList<S> successor = new ArrayList<S>(list.size());
            BitSet acceptanceSets = new BitSet();
            for (int i = 0; i < list.size(); ++i) {
                S state = list.get(i);
                if (state == null) {
                    assert (!this.fastNull);
                    successor.add(null);
                    continue;
                }
                Edge<S> edge = this.getAutomaton(i).edge(state, valuation);
                if (edge == null) {
                    if (this.fastNull) {
                        return null;
                    }
                    successor.add(null);
                    continue;
                }
                successor.add(edge.successor());
                if (this.collapseBuchi) {
                    assert (this.all.isEmpty());
                    assert (this.coBuchi.isEmpty());
                    assert (edge.largestAcceptanceSet() <= 0);
                    if (!edge.hasAcceptanceSets()) continue;
                    acceptanceSets.set(0);
                    continue;
                }
                int offset = this.getOffset(i);
                if (offset > 0) {
                    PrimitiveIterator.OfInt iterator = edge.acceptanceSetIterator();
                    while (iterator.hasNext()) {
                        acceptanceSets.set(iterator.nextInt() + offset);
                    }
                    continue;
                }
                if (offset != 0 || !edge.hasAcceptanceSets()) continue;
                acceptanceSets.set(0);
            }
            return Edge.of(Collections.unmodifiableList(successor), acceptanceSets);
        }
    }
}

