/*
 * Decompiled with CFR 0.152.
 */
package owl.automaton;

import com.google.common.base.Preconditions;
import com.google.common.collect.HashBasedTable;
import com.google.common.collect.MultimapBuilder;
import com.google.common.collect.Sets;
import com.google.common.collect.Table;
import java.util.BitSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import org.immutables.value.Value;
import owl.automaton.Automaton;
import owl.automaton.ImmutableViewSettings;
import owl.automaton.InitialComponentStateTuple;
import owl.automaton.MutableAutomaton;
import owl.automaton.MutableAutomatonFactory;
import owl.automaton.Views;
import owl.automaton.acceptance.GeneralizedBuchiAcceptance;
import owl.automaton.acceptance.NoneAcceptance;
import owl.automaton.acceptance.OmegaAcceptance;
import owl.automaton.algorithms.EmptinessCheck;
import owl.automaton.algorithms.SccDecomposition;
import owl.automaton.edge.Edge;
import owl.automaton.ldba.LimitDeterministicAutomaton;
import owl.automaton.ldba.LimitDeterministicAutomatonImpl;
import owl.automaton.util.AnnotatedState;
import owl.collections.ValuationSet;
import owl.util.annotation.Tuple;

public final class AutomatonUtil {
    private AutomatonUtil() {
    }

    public static Automaton<Object, OmegaAcceptance> cast(Object automaton) {
        return AutomatonUtil.cast(automaton, OmegaAcceptance.class);
    }

    public static <A extends OmegaAcceptance> Automaton<Object, A> cast(Object automaton, Class<A> acceptanceClass) {
        return AutomatonUtil.cast(automaton, Object.class, acceptanceClass);
    }

    public static <S, A extends OmegaAcceptance> Automaton<S, A> cast(Object automaton, Class<S> stateClass, Class<A> acceptanceClass) {
        Preconditions.checkArgument((boolean)(automaton instanceof Automaton), (String)"Expected automaton, got %s", (Object)automaton.getClass().getName());
        Automaton castedAutomaton = (Automaton)automaton;
        AutomatonUtil.checkAcceptanceClass(castedAutomaton, acceptanceClass);
        assert (AutomatonUtil.checkStateClass(castedAutomaton, stateClass));
        return castedAutomaton;
    }

    public static <S, A extends OmegaAcceptance> Automaton<S, A> cast(Automaton<S, ?> automaton, Class<A> acceptanceClass) {
        AutomatonUtil.checkAcceptanceClass(automaton, acceptanceClass);
        return automaton;
    }

    private static <S> boolean checkAcceptanceClass(Automaton<S, ?> automaton, Class<?> clazz) {
        Preconditions.checkArgument((boolean)clazz.isInstance(automaton.acceptance()), (String)"Expected acceptance type %s, got %s", (Object)clazz.getName(), automaton.acceptance().getClass());
        return true;
    }

    private static <S> boolean checkStateClass(Automaton<S, ?> automaton, Class<?> clazz) {
        if (Object.class.equals(clazz)) {
            return true;
        }
        for (S state : automaton.states()) {
            Preconditions.checkArgument((boolean)clazz.isInstance(state), (String)"Expected states of type %s but got %s.", (Object)clazz.getName(), (Object)state.getClass().getName());
        }
        return true;
    }

    public static <S> void forEachNonTransientEdge(Automaton<S, ?> automaton, BiConsumer<S, Edge<S>> action) {
        List<Set<S>> sccs = SccDecomposition.computeSccs(automaton, false);
        for (Set scc : sccs) {
            for (Object state : scc) {
                automaton.forEachEdge(state, edge -> {
                    if (scc.contains(edge.successor())) {
                        action.accept(state, (Edge)edge);
                    }
                });
            }
        }
    }

    public static <S> Map<S, ValuationSet> getIncompleteStates(final Automaton<S, ?> automaton) {
        final HashMap incompleteStates = new HashMap();
        Automaton.LabelledEdgeVisitor visitor = new Automaton.LabelledEdgeVisitor<S>(){
            private final ValuationSet emptyValuationSet;
            private ValuationSet valuationSet;
            {
                this.valuationSet = this.emptyValuationSet = automaton.factory().empty();
            }

            @Override
            public void visitLabelledEdge(Edge<S> edge, ValuationSet valuationSet) {
                this.valuationSet = this.valuationSet.union(valuationSet);
            }

            @Override
            public void enter(S state) {
                this.valuationSet = this.emptyValuationSet;
            }

            @Override
            public void exit(S state) {
                if (!this.valuationSet.isUniverse()) {
                    incompleteStates.put(state, this.valuationSet.complement());
                }
                this.valuationSet = this.emptyValuationSet;
            }
        };
        automaton.accept(visitor);
        return incompleteStates;
    }

    public static <S> Set<S> getNondeterministicStates(final Automaton<S, ?> automaton) {
        final HashSet nondeterministicStates = new HashSet();
        Automaton.LabelledEdgeVisitor visitor = new Automaton.LabelledEdgeVisitor<S>(){
            private final ValuationSet emptyValuationSet;
            private ValuationSet valuationSet;
            private boolean nondeterministicState;
            {
                this.valuationSet = this.emptyValuationSet = automaton.factory().empty();
                this.nondeterministicState = false;
            }

            @Override
            public void visitLabelledEdge(Edge<S> edge, ValuationSet valuationSet) {
                if (this.nondeterministicState || this.valuationSet.intersects(valuationSet)) {
                    this.nondeterministicState = true;
                } else {
                    this.valuationSet = valuationSet.union(valuationSet);
                }
            }

            @Override
            public void enter(S state) {
                this.nondeterministicState = false;
                this.valuationSet = this.emptyValuationSet;
            }

            @Override
            public void exit(S state) {
                if (this.nondeterministicState) {
                    nondeterministicStates.add(state);
                }
            }
        };
        automaton.accept(visitor);
        return nondeterministicStates;
    }

    public static <S> BitSet getAcceptanceSets(Automaton<S, ?> automaton, Set<S> states) {
        BitSet set = new BitSet();
        for (S state : states) {
            automaton.forEachEdge(state, edge -> {
                if (states.contains(edge.successor())) {
                    edge.acceptanceSetIterator().forEachRemaining(set::set);
                }
            });
        }
        return set;
    }

    public static <S, B extends GeneralizedBuchiAcceptance> Optional<LimitDeterministicAutomaton<InitialComponentState<S>, S, B, Void>> ldbaSplit(Automaton<S, B> automaton) {
        HashSet<S> acceptingSccStates = new HashSet<S>();
        for (Set<S> scc : SccDecomposition.computeSccs(automaton)) {
            ImmutableViewSettings viewSettings = Views.builder().initialStates(Set.of(scc.iterator().next())).stateFilter(scc::contains).build();
            if (EmptinessCheck.isEmpty(Views.createView(automaton, viewSettings))) continue;
            acceptingSccStates.addAll(scc);
        }
        Automaton<S, B> acceptingComponent = Views.replaceInitialState(automaton, acceptingSccStates);
        if (!acceptingComponent.is(Automaton.Property.SEMI_DETERMINISTIC)) {
            return Optional.empty();
        }
        MutableAutomaton<InitialComponentState, NoneAcceptance> initialComponent = MutableAutomatonFactory.create(NoneAcceptance.INSTANCE, automaton.factory());
        HashBasedTable jumps = HashBasedTable.create();
        for (Object state : Sets.difference(automaton.initialStates(), acceptingComponent.states())) {
            initialComponent.addInitialState(InitialComponentState.of(state));
        }
        for (Object state : Sets.difference(automaton.states(), acceptingComponent.states())) {
            InitialComponentState initialComponentState = InitialComponentState.of(state);
            initialComponent.addState(initialComponentState);
            automaton.forEachLabelledEdge(state, (arg_0, arg_1) -> AutomatonUtil.lambda$ldbaSplit$3(acceptingComponent, (Table)jumps, initialComponentState, initialComponent, arg_0, arg_1));
        }
        initialComponent.trim();
        LimitDeterministicAutomatonImpl ldba = new LimitDeterministicAutomatonImpl(initialComponent, MutableAutomatonFactory.copy(acceptingComponent), MultimapBuilder.hashKeys().hashSetValues().build(), jumps, Sets.intersection(automaton.initialStates(), acceptingComponent.states()));
        return Optional.of(ldba);
    }

    private static /* synthetic */ void lambda$ldbaSplit$3(Automaton acceptingComponent, Table jumps, InitialComponentState initialComponentState, MutableAutomaton initialComponent, Edge edge, ValuationSet valuation) {
        Object successor = edge.successor();
        if (acceptingComponent.states().contains(successor)) {
            jumps.row((Object)initialComponentState).compute(valuation, (x, oldSet) -> {
                if (oldSet == null) {
                    return new HashSet<Object>(Set.of(successor));
                }
                oldSet.add(successor);
                return oldSet;
            });
        } else {
            initialComponent.addEdge(initialComponentState, valuation, Edge.of(InitialComponentState.of(successor)));
        }
    }

    @Tuple
    @Value.Immutable
    public static abstract class InitialComponentState<S>
    implements AnnotatedState<S> {
        private static <S> InitialComponentState<S> of(S state) {
            return InitialComponentStateTuple.create(state);
        }
    }
}

