/*
 * Decompiled with CFR 0.152.
 */
package owl.automaton.acceptance;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Stream;
import jhoafparser.ast.Atom;
import jhoafparser.ast.AtomAcceptance;
import jhoafparser.ast.BooleanExpression;

public final class BooleanExpressions {
    private BooleanExpressions() {
    }

    public static <T extends Atom> BooleanExpression<T> createConjunction(Iterable<BooleanExpression<T>> conjuncts) {
        return BooleanExpressions.createConjunction(conjuncts.iterator());
    }

    public static <T extends Atom> BooleanExpression<T> createConjunction(Stream<BooleanExpression<T>> conjuncts) {
        return BooleanExpressions.createConjunction(conjuncts.iterator());
    }

    public static <T extends Atom> BooleanExpression<T> createConjunction(Iterator<BooleanExpression<T>> conjuncts) {
        if (!conjuncts.hasNext()) {
            return new BooleanExpression(true);
        }
        BooleanExpression conjunction = conjuncts.next();
        while (conjuncts.hasNext()) {
            conjunction = conjunction.and(conjuncts.next());
        }
        return conjunction;
    }

    public static <T extends Atom> BooleanExpression<T> createDisjunction(Iterable<BooleanExpression<T>> disjuncts) {
        return BooleanExpressions.createDisjunction(disjuncts.iterator());
    }

    public static <T extends Atom> BooleanExpression<T> createDisjunction(Stream<BooleanExpression<T>> disjuncts) {
        return BooleanExpressions.createDisjunction(disjuncts.iterator());
    }

    public static <T extends Atom> BooleanExpression<T> createDisjunction(Iterator<BooleanExpression<T>> disjuncts) {
        if (!disjuncts.hasNext()) {
            return new BooleanExpression(false);
        }
        BooleanExpression disjunction = disjuncts.next();
        while (disjuncts.hasNext()) {
            disjunction = disjunction.or(disjuncts.next());
        }
        return disjunction;
    }

    static <T extends Atom> List<BooleanExpression<T>> getConjuncts(BooleanExpression<T> exp) {
        if (exp.isTRUE()) {
            return new ArrayList<BooleanExpression<T>>();
        }
        if (!exp.isAND()) {
            return Lists.newArrayList((Object[])new BooleanExpression[]{exp});
        }
        List<BooleanExpression<T>> conjuncts = BooleanExpressions.getConjuncts(exp.getLeft());
        conjuncts.addAll(BooleanExpressions.getConjuncts(exp.getRight()));
        return conjuncts;
    }

    static <T extends Atom> List<BooleanExpression<T>> getDisjuncts(BooleanExpression<T> exp) {
        if (exp.isFALSE()) {
            return new ArrayList<BooleanExpression<T>>();
        }
        if (!exp.isOR()) {
            return Lists.newArrayList((Object[])new BooleanExpression[]{exp});
        }
        List<BooleanExpression<T>> disjuncts = BooleanExpressions.getDisjuncts(exp.getLeft());
        disjuncts.addAll(BooleanExpressions.getDisjuncts(exp.getRight()));
        return disjuncts;
    }

    public static BooleanExpression<AtomAcceptance> mkFin(int number) {
        return new BooleanExpression((Atom)new AtomAcceptance(AtomAcceptance.Type.TEMPORAL_FIN, Integer.valueOf(number), false));
    }

    public static BooleanExpression<AtomAcceptance> mkInf(int number) {
        return new BooleanExpression((Atom)new AtomAcceptance(AtomAcceptance.Type.TEMPORAL_INF, Integer.valueOf(number), false));
    }
}

