/*
 * Decompiled with CFR 0.152.
 */
package owl.automaton.acceptance;

import com.google.common.base.Preconditions;
import it.unimi.dsi.fastutil.ints.IntIterator;
import it.unimi.dsi.fastutil.ints.IntIterators;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.function.IntConsumer;
import java.util.function.IntPredicate;
import javax.annotation.Nonnegative;
import jhoafparser.ast.AtomAcceptance;
import jhoafparser.ast.BooleanExpression;
import owl.automaton.acceptance.BooleanExpressions;
import owl.automaton.acceptance.OmegaAcceptance;
import owl.automaton.edge.Edge;

public class GeneralizedRabinAcceptance
extends OmegaAcceptance {
    final List<RabinPair> pairs;
    @Nonnegative
    private final int setCount;

    GeneralizedRabinAcceptance(List<RabinPair> pairs) {
        this.pairs = List.copyOf(pairs);
        this.setCount = this.computeSetCount(this.pairs);
        int i = 0;
        for (RabinPair pair : this.pairs) {
            Preconditions.checkArgument((i == pair.finIndex ? 1 : 0) != 0);
            Preconditions.checkArgument((pair.finIndex <= pair.infIndex ? 1 : 0) != 0);
            i = pair.infIndex + 1;
        }
        Preconditions.checkArgument((i == this.setCount ? 1 : 0) != 0);
    }

    @Override
    public BitSet acceptingSet() {
        if (this.pairs.isEmpty()) {
            throw new NoSuchElementException();
        }
        BitSet set = new BitSet();
        this.pairs.get(0).forEachInfSet(set::set);
        return set;
    }

    @Override
    public BitSet rejectingSet() {
        BitSet set = new BitSet();
        this.pairs.forEach(x -> set.set(x.finIndex));
        return set;
    }

    private int computeSetCount(List<RabinPair> pairs) {
        int count = 0;
        for (RabinPair pair : pairs) {
            count += pair.infSetCount() + 1;
        }
        return count;
    }

    public static GeneralizedRabinAcceptance of(RabinPair ... pairs) {
        return GeneralizedRabinAcceptance.of(List.of(pairs));
    }

    public static GeneralizedRabinAcceptance of(List<RabinPair> pairs) {
        return new GeneralizedRabinAcceptance(pairs);
    }

    public static GeneralizedRabinAcceptance of(BooleanExpression<AtomAcceptance> expression) {
        Builder builder = new Builder();
        int setCount = 0;
        for (BooleanExpression<AtomAcceptance> dis : BooleanExpressions.getDisjuncts(expression)) {
            int fin = -1;
            int infSets = 0;
            for (BooleanExpression<AtomAcceptance> element : BooleanExpressions.getConjuncts(dis)) {
                AtomAcceptance atom = (AtomAcceptance)element.getAtom();
                switch (atom.getType()) {
                    case TEMPORAL_FIN: {
                        Preconditions.checkArgument((fin == -1 ? 1 : 0) != 0);
                        fin = atom.getAcceptanceSet();
                        Preconditions.checkArgument((fin == setCount ? 1 : 0) != 0);
                        break;
                    }
                    case TEMPORAL_INF: {
                        Preconditions.checkArgument((fin + infSets + 1 == atom.getAcceptanceSet() ? 1 : 0) != 0);
                        ++infSets;
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException("Generalized-Rabin Acceptance not well-formed.");
                    }
                }
                ++setCount;
            }
            Preconditions.checkArgument((fin != -1 ? 1 : 0) != 0);
            builder.add(infSets);
        }
        return builder.build();
    }

    @Override
    public int acceptanceSets() {
        return this.setCount;
    }

    @Override
    public BooleanExpression<AtomAcceptance> booleanExpression() {
        return BooleanExpressions.createDisjunction(this.pairs.stream().map(rec$ -> ((RabinPair)rec$).booleanExpression()));
    }

    @Override
    public String name() {
        return "generalized-Rabin";
    }

    @Override
    public List<Object> nameExtra() {
        ArrayList<Object> extra = new ArrayList<Object>(this.pairs.size() + 1);
        extra.add(this.pairs.size());
        for (RabinPair pair : this.pairs) {
            extra.add(pair.infSetCount());
        }
        return extra;
    }

    public List<RabinPair> pairs() {
        return this.pairs;
    }

    @Override
    public boolean isWellFormedEdge(Edge<?> edge) {
        return edge.largestAcceptanceSet() < this.setCount;
    }

    public GeneralizedRabinAcceptance filter(IntPredicate predicate) {
        ArrayList<RabinPair> newPairs = new ArrayList<RabinPair>(this.pairs.size());
        int removedIndices = 0;
        for (RabinPair pair : this.pairs) {
            if (predicate.test(pair.finIndex)) {
                removedIndices += pair.infSetCount() + 1;
                continue;
            }
            int removedInfIndices = 0;
            for (int i = pair.finIndex + 1; i <= pair.infIndex; ++i) {
                if (!predicate.test(i)) continue;
                ++removedInfIndices;
            }
            assert (pair.finIndex >= removedIndices);
            assert (pair.infIndex >= removedIndices + removedInfIndices);
            newPairs.add(new RabinPair(pair.finIndex - removedIndices, pair.infIndex - (removedIndices + removedInfIndices)));
            removedIndices += removedInfIndices;
        }
        return new GeneralizedRabinAcceptance(newPairs);
    }

    public static final class Builder {
        private final List<RabinPair> pairs = new ArrayList<RabinPair>();
        private int sets = 0;

        public RabinPair add(@Nonnegative int infSets) {
            RabinPair pair = new RabinPair(this.sets, this.sets + infSets);
            this.pairs.add(pair);
            this.sets += 1 + infSets;
            return pair;
        }

        public GeneralizedRabinAcceptance build() {
            return GeneralizedRabinAcceptance.of(this.pairs);
        }
    }

    public static final class RabinPair {
        @Nonnegative
        final int finIndex;
        @Nonnegative
        final int infIndex;

        RabinPair(@Nonnegative int finIndex, int infIndex) {
            assert (infIndex >= finIndex);
            this.finIndex = finIndex;
            this.infIndex = infIndex;
        }

        public static RabinPair of(@Nonnegative int finIndex) {
            return RabinPair.ofGeneralized(finIndex, 1);
        }

        public static RabinPair ofGeneralized(@Nonnegative int finIndex, @Nonnegative int infSets) {
            return new RabinPair(finIndex, finIndex + infSets);
        }

        public boolean contains(BitSet indices) {
            return !indices.get(this.finIndex, this.infIndex + 1).isEmpty();
        }

        public boolean contains(Edge<?> edge) {
            return edge.inSet(this.finIndex) || this.containsInfinite(edge);
        }

        public boolean containsInfinite(Edge<?> edge) {
            for (int i = this.finIndex + 1; i <= this.infIndex; ++i) {
                if (!edge.inSet(i)) continue;
                return true;
            }
            return false;
        }

        public void forEachIndex(IntConsumer action) {
            action.accept(this.finIndex);
            this.forEachInfSet(action);
        }

        public void forEachInfSet(IntConsumer action) {
            for (int i = this.finIndex + 1; i <= this.infIndex; ++i) {
                action.accept(i);
            }
        }

        private BooleanExpression<AtomAcceptance> booleanExpression() {
            BooleanExpression acceptance = BooleanExpressions.mkFin(this.finIndex);
            for (int index = this.finIndex + 1; index <= this.infIndex; ++index) {
                acceptance = acceptance.and(BooleanExpressions.mkInf(index));
            }
            return acceptance;
        }

        @Nonnegative
        public int finSet() {
            return this.finIndex;
        }

        @Nonnegative
        public int infSet(int number) {
            assert (this.finIndex + number < this.infIndex);
            return this.finIndex + 1 + number;
        }

        @Nonnegative
        public int infSetCount() {
            return this.infIndex - this.finIndex;
        }

        public boolean hasInfSet() {
            return this.infSetCount() > 0;
        }

        public IntIterator infSetIterator() {
            return IntIterators.fromTo((int)(this.finIndex + 1), (int)(this.infIndex + 1));
        }

        public boolean isInfinite(int i) {
            return this.finIndex < i && i <= this.infIndex;
        }

        public int infSet() {
            Preconditions.checkState((this.infSetCount() == 1 ? 1 : 0) != 0);
            return this.infIndex;
        }

        public String toString() {
            return "(" + this.finIndex + ", " + this.infIndex + ")";
        }
    }
}

