/*
 * Decompiled with CFR 0.152.
 */
package owl.automaton.algorithms;

import com.google.common.base.Preconditions;
import java.util.List;
import owl.automaton.Automaton;
import owl.automaton.AutomatonOperations;
import owl.automaton.AutomatonUtil;
import owl.automaton.Views;
import owl.automaton.acceptance.BuchiAcceptance;
import owl.automaton.acceptance.CoBuchiAcceptance;
import owl.automaton.algorithms.EmptinessCheck;

public final class LanguageAnalysis {
    private LanguageAnalysis() {
    }

    public static <S> boolean contains(Automaton<S, BuchiAcceptance> automaton1, Automaton<S, BuchiAcceptance> automaton2) {
        Preconditions.checkArgument((boolean)automaton1.is(Automaton.Property.DETERMINISTIC), (Object)"First argument needs to be deterministic.");
        Preconditions.checkArgument((boolean)automaton2.is(Automaton.Property.DETERMINISTIC), (Object)"Second argument needs to be deterministic.");
        Automaton<Object, BuchiAcceptance> casted1 = AutomatonUtil.cast(automaton1, Object.class, BuchiAcceptance.class);
        Automaton<Object, BuchiAcceptance> casted2 = AutomatonUtil.cast(automaton2, Object.class, BuchiAcceptance.class);
        return EmptinessCheck.isEmpty(AutomatonOperations.intersection(List.of(casted1, AutomatonUtil.cast(Views.complement(casted2, new Object()), CoBuchiAcceptance.class))));
    }
}

