/*
 * Decompiled with CFR 0.152.
 */
package owl.automaton.algorithms;

import com.google.common.collect.Iterables;
import java.io.Serializable;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Deque;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import owl.automaton.Automaton;
import owl.automaton.SuccessorFunction;

public final class SccDecomposition<S> {
    static final int NO_LINK = Integer.MAX_VALUE;
    private final Deque<S> explorationStack = new ArrayDeque<S>();
    private final boolean includeTransient;
    private final Deque<TarjanState<S>> path = new ArrayDeque<TarjanState<S>>();
    private final Set<S> processedNodes = new HashSet<S>();
    private final List<Set<S>> sccs = new ArrayList<Set<S>>();
    private final Map<S, TarjanState<S>> stateMap = new HashMap<S, TarjanState<S>>();
    private final SuccessorFunction<S> successorFunction;
    private int index = 0;

    private SccDecomposition(SuccessorFunction<S> successorFunction, boolean includeTransient) {
        this.successorFunction = successorFunction;
        this.includeTransient = includeTransient;
    }

    public static <S> List<Set<S>> computeSccs(Automaton<S, ?> automaton) {
        return SccDecomposition.computeSccs(automaton, true);
    }

    public static <S> List<Set<S>> computeSccs(Automaton<S, ?> automaton, boolean includeTransient) {
        return SccDecomposition.computeSccs(automaton::successors, automaton.initialStates(), includeTransient);
    }

    public static <S> List<Set<S>> computeSccs(SuccessorFunction<S> function, S initialState) {
        return SccDecomposition.computeSccs(function, Set.of(initialState), true);
    }

    public static <S> List<Set<S>> computeSccs(SuccessorFunction<S> function, Set<S> initialStates) {
        return SccDecomposition.computeSccs(function, initialStates, true);
    }

    public static <S> List<Set<S>> computeSccs(SuccessorFunction<S> function, S initialState, boolean includeTransient) {
        return SccDecomposition.computeSccs(function, Set.of(initialState), includeTransient);
    }

    public static <S> List<Set<S>> computeSccs(SuccessorFunction<S> function, Set<S> initialStates, boolean includeTransient) {
        if (initialStates.isEmpty()) {
            return List.of();
        }
        SccDecomposition<S> decomposition = new SccDecomposition<S>(function, includeTransient);
        for (S initialState : initialStates) {
            if (decomposition.stateMap.containsKey(initialState) || decomposition.processedNodes.contains(initialState)) continue;
            super.run(initialState);
        }
        assert (includeTransient || decomposition.sccs.stream().noneMatch(scc -> SccDecomposition.isTransient(function, scc)));
        return decomposition.sccs;
    }

    public static <S> boolean isTransient(SuccessorFunction<S> successorFunction, Set<S> scc) {
        if (scc.size() > 1) {
            return false;
        }
        Object state = Iterables.getOnlyElement(scc);
        return !successorFunction.apply(state).contains(state);
    }

    public static <S> boolean isTrap(Automaton<S, ?> automaton, Set<S> trap) {
        return trap.stream().allMatch(s -> trap.containsAll(automaton.successors(s)));
    }

    private TarjanState<S> create(S node) {
        assert (!this.stateMap.containsKey(node) && !this.processedNodes.contains(node)) : String.format("Node %s already processed", node);
        int nodeIndex = this.index++;
        Iterator successorIterator = this.successorFunction.apply((Object)node).iterator();
        TarjanState<S> state = new TarjanState<S>(node, nodeIndex, successorIterator);
        this.explorationStack.push(node);
        this.stateMap.put(node, state);
        return state;
    }

    private void run(S initial) {
        assert (this.path.isEmpty());
        TarjanState<S> state = this.create(initial);
        block0: while (true) {
            Object node = state.node;
            int nodeIndex = state.nodeIndex;
            Iterator successorIterator = state.successorIterator;
            while (successorIterator.hasNext()) {
                Object successor = successorIterator.next();
                if (Objects.equals(node, successor)) {
                    if (state.lowLink != Integer.MAX_VALUE) continue;
                    state.lowLink = nodeIndex;
                    continue;
                }
                if (this.processedNodes.contains(successor)) continue;
                TarjanState<S> successorState = this.stateMap.get(successor);
                assert (successorState != state);
                if (successorState == null) {
                    this.path.push(state);
                    state = this.create(successor);
                    continue block0;
                }
                int successorIndex = successorState.nodeIndex;
                assert (successorIndex != nodeIndex);
                int successorLowLink = successorState.getLowLink();
                if (successorLowLink < state.lowLink) {
                    state.lowLink = successorLowLink;
                }
                assert (state.lowLink <= nodeIndex);
            }
            int lowLink = state.lowLink;
            if (lowLink == Integer.MAX_VALUE) {
                assert (Objects.equals(this.explorationStack.peek(), node));
                assert (SccDecomposition.isTransient(this.successorFunction, Set.of(node)));
                if (this.includeTransient) {
                    this.sccs.add(Set.of(node));
                }
                this.explorationStack.pop();
                this.processedNodes.add(node);
            } else if (lowLink == nodeIndex) {
                Set scc;
                assert (!this.explorationStack.isEmpty());
                S stackNode = this.explorationStack.pop();
                if (stackNode == node) {
                    scc = Set.of(node);
                    assert (!SccDecomposition.isTransient(this.successorFunction, scc));
                } else {
                    scc = new HashSet();
                    scc.add(stackNode);
                    do {
                        stackNode = this.explorationStack.pop();
                        scc.add(stackNode);
                    } while (stackNode != node);
                }
                this.sccs.add(Set.copyOf(scc));
                this.stateMap.keySet().removeAll(scc);
                this.processedNodes.addAll(scc);
            } else {
                assert (!this.path.isEmpty() && lowLink < nodeIndex);
                TarjanState<S> predecessorState = this.path.getFirst();
                int predecessorLowLink = predecessorState.lowLink;
                if (lowLink < predecessorLowLink) {
                    predecessorState.lowLink = lowLink;
                }
            }
            if (this.path.isEmpty()) break;
            state = this.path.pop();
        }
        assert (this.path.isEmpty());
    }

    private static final class TarjanState<S> {
        final S node;
        final int nodeIndex;
        final Iterator<S> successorIterator;
        int lowLink;

        TarjanState(S node, int nodeIndex, Iterator<S> successorIterator) {
            this.node = node;
            this.nodeIndex = nodeIndex;
            this.successorIterator = successorIterator;
            this.lowLink = Integer.MAX_VALUE;
        }

        int getLowLink() {
            return this.lowLink == Integer.MAX_VALUE ? this.nodeIndex : this.lowLink;
        }

        public String toString() {
            return this.nodeIndex + "(" + (Serializable)(this.lowLink == Integer.MAX_VALUE ? "X" : Integer.valueOf(this.lowLink)) + ") " + this.node;
        }
    }
}

