/*
 * Decompiled with CFR 0.152.
 */
package owl.automaton.edge;

import de.tum.in.naturals.bitset.BitSets;
import java.util.BitSet;
import java.util.Objects;
import java.util.PrimitiveIterator;
import javax.annotation.Nonnegative;
import javax.annotation.concurrent.Immutable;
import owl.automaton.edge.Edge;

@Immutable
final class EdgeGeneric<S>
implements Edge<S> {
    private final BitSet acceptance;
    private final S successor;

    EdgeGeneric(S successor, BitSet acceptance) {
        assert (acceptance.cardinality() > 1);
        this.acceptance = Objects.requireNonNull(acceptance);
        this.successor = Objects.requireNonNull(successor);
    }

    @Override
    public PrimitiveIterator.OfInt acceptanceSetIterator() {
        return BitSets.iterator((BitSet)this.acceptance);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof EdgeGeneric)) {
            return false;
        }
        EdgeGeneric other = (EdgeGeneric)o;
        return Objects.equals(this.acceptance, other.acceptance) && Objects.equals(this.successor, other.successor);
    }

    @Override
    public S successor() {
        return this.successor;
    }

    @Override
    public boolean hasAcceptanceSets() {
        return true;
    }

    public int hashCode() {
        return 31 * this.acceptance.hashCode() + this.successor.hashCode();
    }

    @Override
    public boolean inSet(@Nonnegative int i) {
        return this.acceptance.get(i);
    }

    @Override
    public int largestAcceptanceSet() {
        return this.acceptance.length() - 1;
    }

    @Override
    public int smallestAcceptanceSet() {
        return this.acceptance.nextSetBit(0);
    }

    @Override
    public <T> EdgeGeneric<T> withSuccessor(T successor) {
        return new EdgeGeneric<T>(successor, this.acceptance);
    }

    public String toString() {
        PrimitiveIterator.OfInt acceptanceSetIterator = this.acceptanceSetIterator();
        StringBuilder builder = new StringBuilder(10);
        builder.append(acceptanceSetIterator.nextInt());
        acceptanceSetIterator.forEachRemaining(x -> builder.append(", ").append(x));
        return "-> " + this.successor + " {" + builder + "}";
    }
}

