/*
 * Decompiled with CFR 0.152.
 */
package owl.automaton.edge;

import it.unimi.dsi.fastutil.ints.IntIterators;
import java.io.Serializable;
import java.util.Objects;
import java.util.PrimitiveIterator;
import javax.annotation.Nonnegative;
import javax.annotation.concurrent.Immutable;
import owl.automaton.edge.Edge;

@Immutable
final class EdgeSingleton<S>
implements Edge<S> {
    private static final int EMPTY_ACCEPTANCE = -1;
    private final int acceptance;
    private final S successor;

    EdgeSingleton(S successor) {
        this.acceptance = -1;
        this.successor = Objects.requireNonNull(successor);
    }

    EdgeSingleton(S successor, @Nonnegative int acceptance) {
        Objects.checkIndex(acceptance, Integer.MAX_VALUE);
        this.acceptance = acceptance;
        this.successor = Objects.requireNonNull(successor);
    }

    @Override
    public PrimitiveIterator.OfInt acceptanceSetIterator() {
        return this.hasAcceptanceSets() ? IntIterators.singleton((int)this.acceptance) : IntIterators.EMPTY_ITERATOR;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof EdgeSingleton)) {
            return false;
        }
        EdgeSingleton other = (EdgeSingleton)o;
        return this.acceptance == other.acceptance && Objects.equals(this.successor, other.successor);
    }

    @Override
    public S successor() {
        return this.successor;
    }

    @Override
    public boolean hasAcceptanceSets() {
        return this.acceptance != -1;
    }

    public int hashCode() {
        return 31 * (31 + this.successor.hashCode()) + this.acceptance;
    }

    @Override
    public boolean inSet(@Nonnegative int i) {
        Objects.checkIndex(i, Integer.MAX_VALUE);
        return i == this.acceptance;
    }

    @Override
    public int largestAcceptanceSet() {
        return this.hasAcceptanceSets() ? this.acceptance : -1;
    }

    @Override
    public int smallestAcceptanceSet() {
        return this.hasAcceptanceSets() ? this.acceptance : Integer.MAX_VALUE;
    }

    public String toString() {
        return "-> " + this.successor + " {" + (Serializable)(this.hasAcceptanceSets() ? Integer.valueOf(this.acceptance) : "") + "}";
    }

    @Override
    public <T> EdgeSingleton<T> withSuccessor(T successor) {
        return this.hasAcceptanceSets() ? new EdgeSingleton<T>(successor, this.acceptance) : new EdgeSingleton<T>(successor);
    }
}

