/*
 * Decompiled with CFR 0.152.
 */
package owl.automaton.edge;

import java.util.BitSet;
import java.util.Map;
import java.util.Objects;
import java.util.function.BiConsumer;
import java.util.function.Function;
import owl.automaton.edge.Edge;
import owl.collections.ValuationSet;

public final class LabelledEdge<S> {
    public final Edge<S> edge;
    public final ValuationSet valuations;

    private LabelledEdge(Edge<S> edge, ValuationSet valuations) {
        assert (!valuations.isEmpty());
        this.edge = edge;
        this.valuations = valuations;
    }

    public static <S> LabelledEdge<S> of(S state, ValuationSet valuations) {
        return LabelledEdge.of(Edge.of(state), valuations);
    }

    public static <S> LabelledEdge<S> of(S state, int acceptance, ValuationSet valuations) {
        return LabelledEdge.of(Edge.of(state, acceptance), valuations);
    }

    public static <S> LabelledEdge<S> of(S state, BitSet acceptance, ValuationSet valuations) {
        return LabelledEdge.of(Edge.of(state, acceptance), valuations);
    }

    public static <S> LabelledEdge<S> of(Edge<S> edge, ValuationSet valuations) {
        return new LabelledEdge<S>(edge, valuations);
    }

    public static <S> LabelledEdge<S> of(Map.Entry<Edge<S>, ValuationSet> entry) {
        return LabelledEdge.of(entry.getKey(), entry.getValue());
    }

    public Edge<S> edge() {
        return this.edge;
    }

    public ValuationSet valuations() {
        return this.valuations;
    }

    public S successor() {
        return this.edge.successor();
    }

    public <T> LabelledEdge<T> map(Function<Edge<S>, Edge<T>> map) {
        return LabelledEdge.of(map.apply(this.edge), this.valuations);
    }

    public void forEach(BiConsumer<Edge<S>, BitSet> action) {
        this.valuations.forEach((BitSet valuation) -> action.accept(this.edge, (BitSet)valuation));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof LabelledEdge)) {
            return false;
        }
        LabelledEdge that = (LabelledEdge)o;
        return Objects.equals(this.edge, that.edge) && Objects.equals(this.valuations, that.valuations);
    }

    public int hashCode() {
        return this.edge.hashCode() ^ this.valuations.hashCode();
    }

    public String toString() {
        return String.format("%s(%s)", this.edge, this.valuations);
    }
}

