/*
 * Decompiled with CFR 0.152.
 */
package owl.automaton.ldba;

import com.google.common.collect.HashBasedTable;
import com.google.common.collect.Iterables;
import com.google.common.collect.Multimap;
import com.google.common.collect.MultimapBuilder;
import com.google.common.collect.SetMultimap;
import com.google.common.collect.Table;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.logging.Level;
import java.util.logging.Logger;
import owl.automaton.Automaton;
import owl.automaton.MutableAutomaton;
import owl.automaton.acceptance.GeneralizedBuchiAcceptance;
import owl.automaton.acceptance.NoneAcceptance;
import owl.automaton.algorithms.SccDecomposition;
import owl.automaton.ldba.LimitDeterministicAutomaton;
import owl.automaton.ldba.LimitDeterministicAutomatonImpl;
import owl.automaton.ldba.MutableAutomatonBuilder;
import owl.automaton.minimizations.MinimizationUtil;

public final class LimitDeterministicAutomatonBuilder<S, KeyT, T, B extends GeneralizedBuchiAcceptance, C> {
    private static final Logger logger = Logger.getLogger(MinimizationUtil.class.getName());
    private final MutableAutomatonBuilder<KeyT, T, B> acceptingComponentBuilder;
    private final Set<C> components;
    private final Function<S, Iterable<KeyT>> jumpGenerator;
    private final Function<T, C> getComponent;
    private final Supplier<MutableAutomaton<S, NoneAcceptance>> initialComponentBuilder;
    private final Set<T> initialStates;
    private final Predicate<S> isProtected;
    private final EnumSet<Configuration> optimisations;

    private LimitDeterministicAutomatonBuilder(Supplier<MutableAutomaton<S, NoneAcceptance>> initialComponentBuilder, MutableAutomatonBuilder<KeyT, T, B> acceptingComponentBuilder, Function<S, Iterable<KeyT>> jumpGenerator, Function<T, C> annotations, EnumSet<Configuration> optimisations, Predicate<S> isProtected) {
        this.initialComponentBuilder = initialComponentBuilder;
        this.acceptingComponentBuilder = acceptingComponentBuilder;
        this.optimisations = EnumSet.copyOf(optimisations);
        this.jumpGenerator = jumpGenerator;
        this.initialStates = new HashSet<T>();
        this.components = new HashSet<C>();
        this.getComponent = annotations;
        this.isProtected = isProtected;
    }

    public static <S, T, Acc extends GeneralizedBuchiAcceptance, X2, X3> LimitDeterministicAutomatonBuilder<S, X2, T, Acc, X3> create(Supplier<MutableAutomaton<S, NoneAcceptance>> initialComponentBuilder, MutableAutomatonBuilder<X2, T, Acc> acceptingComponentBuilder, Function<S, Iterable<X2>> jumpGenerator, Function<T, X3> annotations, EnumSet<Configuration> optimisations) {
        return new LimitDeterministicAutomatonBuilder<Object, X2, T, Acc, X3>(initialComponentBuilder, acceptingComponentBuilder, jumpGenerator, annotations, optimisations, x -> false);
    }

    public static <S, T, Acc extends GeneralizedBuchiAcceptance, X2, X3> LimitDeterministicAutomatonBuilder<S, X2, T, Acc, X3> create(Supplier<MutableAutomaton<S, NoneAcceptance>> initialComponentBuilder, MutableAutomatonBuilder<X2, T, Acc> acceptingComponentBuilder, Function<S, Iterable<X2>> jumpGenerator, Function<T, X3> annotations, EnumSet<Configuration> optimisations, Predicate<S> isProtected) {
        return new LimitDeterministicAutomatonBuilder<S, X2, T, Acc, X3>(initialComponentBuilder, acceptingComponentBuilder, jumpGenerator, annotations, optimisations, isProtected);
    }

    public void addInitialStateAcceptingComponent(KeyT key) {
        T state = this.acceptingComponentBuilder.add(key);
        if (state == null) {
            return;
        }
        this.initialStates.add(state);
        C component = this.getComponent.apply(state);
        if (component != null) {
            this.components.add(component);
        }
    }

    public LimitDeterministicAutomaton<S, T, B, C> build() {
        MutableAutomaton initialComponent = this.initialComponentBuilder.get();
        SetMultimap epsilonJumps = MultimapBuilder.hashKeys().hashSetValues().build();
        HashBasedTable valuationSetJumps = HashBasedTable.create();
        this.generateJumps(initialComponent, (Multimap<S, T>)epsilonJumps);
        MutableAutomaton<T, B> acceptingComponent = this.acceptingComponentBuilder.build();
        MinimizationUtil.removeDeadStates(acceptingComponent);
        Set acceptingComponentStates = acceptingComponent.states();
        epsilonJumps.values().retainAll(acceptingComponentStates);
        this.initialStates.retainAll(acceptingComponentStates);
        Predicate<Object> initialComponentProtectedStates = arg_0 -> this.lambda$build$1(epsilonJumps, (Table)valuationSetJumps, arg_0);
        if (this.optimisations.contains((Object)Configuration.REMOVE_EPSILON_TRANSITIONS)) {
            HashSet extendedInitialStates = new HashSet(this.initialStates);
            for (Object state : initialComponent.states()) {
                Map successorJumps = valuationSetJumps.row(state);
                initialComponent.forEachLabelledEdge(state, (edge, valuations) -> {
                    Set targets = epsilonJumps.get(edge.successor());
                    extendedInitialStates.addAll(targets);
                    successorJumps.compute(valuations, (x, existingJumpTargets) -> {
                        if (existingJumpTargets == null) {
                            return new HashSet(targets);
                        }
                        existingJumpTargets.addAll(targets);
                        return existingJumpTargets;
                    });
                });
            }
            epsilonJumps.clear();
            this.removeUnprotectedStates(initialComponent, initialComponentProtectedStates);
            acceptingComponent.initialStates(extendedInitialStates);
            acceptingComponent.trim();
            MinimizationUtil.removeDeadStates(acceptingComponent);
            this.initialStates.retainAll(acceptingComponent.states());
        } else {
            this.removeUnprotectedStates(initialComponent, initialComponentProtectedStates);
        }
        return new LimitDeterministicAutomatonImpl<S, T, B, C>(initialComponent, acceptingComponent, epsilonJumps, valuationSetJumps, this.components, this.getComponent, this.initialStates);
    }

    private void removeUnprotectedStates(MutableAutomaton<S, ?> automaton, Predicate<S> isProtected) {
        for (Set<S> scc : SccDecomposition.computeSccs(automaton)) {
            if (!scc.stream().noneMatch(isProtected) || !SccDecomposition.isTrap(automaton, scc)) continue;
            logger.log(Level.FINER, "Removing scc {0}", scc);
            automaton.removeStateIf(scc::contains);
            automaton.trim();
        }
    }

    private void generateJumps(Automaton<S, NoneAcceptance> initialComponent, Multimap<S, T> epsilonJumps) {
        List<Set<S>> sccs = this.optimisations.contains((Object)Configuration.SUPPRESS_JUMPS_FOR_TRANSIENT_STATES) ? SccDecomposition.computeSccs(initialComponent, true) : List.of(initialComponent.states());
        for (Set<S> scc : sccs) {
            Object state;
            Set<Object> successors;
            if (scc.size() == 1 && !(successors = initialComponent.successors(state = Iterables.getOnlyElement(scc))).contains(state) && !successors.isEmpty()) continue;
            for (S state2 : scc) {
                Iterable<KeyT> jumps = this.jumpGenerator.apply(state2);
                if (jumps == null) continue;
                for (KeyT key : jumps) {
                    T target = this.acceptingComponentBuilder.add(key);
                    if (target == null) continue;
                    C component = this.getComponent.apply(target);
                    if (component != null) {
                        this.components.add(component);
                    }
                    epsilonJumps.put(state2, target);
                }
            }
        }
    }

    private /* synthetic */ boolean lambda$build$1(SetMultimap epsilonJumps, Table valuationSetJumps, Object x) {
        return this.isProtected.test(x) || epsilonJumps.keySet().contains(x) || valuationSetJumps.rowKeySet().contains(x);
    }

    public static enum Configuration {
        SUPPRESS_JUMPS_FOR_TRANSIENT_STATES,
        REMOVE_EPSILON_TRANSITIONS;

    }
}

