/*
 * Decompiled with CFR 0.152.
 */
package owl.ltl;

import java.util.BitSet;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import owl.ltl.Formula;
import owl.ltl.visitors.BinaryVisitor;
import owl.ltl.visitors.IntVisitor;
import owl.ltl.visitors.Visitor;

public final class BooleanConstant
implements Formula {
    public static final BooleanConstant FALSE = new BooleanConstant(false);
    public static final BooleanConstant TRUE = new BooleanConstant(true);
    public final boolean value;

    public static BooleanConstant of(boolean value) {
        return value ? TRUE : FALSE;
    }

    private BooleanConstant(boolean value) {
        this.value = value;
    }

    @Override
    public int accept(IntVisitor v) {
        return v.visit(this);
    }

    @Override
    public <R> R accept(Visitor<R> v) {
        return v.visit(this);
    }

    public <A, B> A accept(BinaryVisitor<B, A> v, B parameter) {
        return v.visit(this, parameter);
    }

    @Override
    public boolean allMatch(Predicate<Formula> predicate) {
        return predicate.test(this);
    }

    @Override
    public boolean anyMatch(Predicate<Formula> predicate) {
        return predicate.test(this);
    }

    public boolean equals(Object o) {
        return this == o;
    }

    public int hashCode() {
        return Boolean.hashCode(this.value);
    }

    @Override
    public boolean isPureEventual() {
        return true;
    }

    @Override
    public boolean isPureUniversal() {
        return true;
    }

    @Override
    public boolean isSuspendable() {
        return true;
    }

    @Override
    public Formula nnf() {
        return this;
    }

    @Override
    @Nonnull
    public BooleanConstant not() {
        return this.value ? FALSE : TRUE;
    }

    @Override
    public Formula temporalStep(BitSet valuation) {
        return this;
    }

    @Override
    public Formula temporalStepUnfold(BitSet valuation) {
        return this;
    }

    public String toString() {
        return this.value ? "true" : "false";
    }

    @Override
    public Formula unfold() {
        return this;
    }

    @Override
    public Formula unfoldTemporalStep(BitSet valuation) {
        return this;
    }
}

