/*
 * Decompiled with CFR 0.152.
 */
package owl.ltl;

import java.util.BitSet;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import owl.ltl.BooleanConstant;
import owl.ltl.Conjunction;
import owl.ltl.Formula;
import owl.ltl.PropositionalFormula;
import owl.ltl.visitors.BinaryVisitor;
import owl.ltl.visitors.IntVisitor;
import owl.ltl.visitors.Visitor;

public final class Disjunction
extends PropositionalFormula {
    public Disjunction(Collection<? extends Formula> disjuncts) {
        super(disjuncts);
    }

    public Disjunction(Formula ... disjuncts) {
        this(Set.of(disjuncts));
    }

    public Disjunction(Stream<? extends Formula> formulaStream) {
        this(formulaStream.collect(Collectors.toUnmodifiableSet()));
    }

    public static Formula of(Formula left, Formula right) {
        return Disjunction.of(List.of(left, right));
    }

    public static Formula of(Formula ... formulas) {
        return Disjunction.of(Stream.of(formulas));
    }

    public static Formula of(Iterable<? extends Formula> iterable) {
        return Disjunction.of(iterable.iterator());
    }

    public static Formula of(Stream<? extends Formula> stream) {
        return Disjunction.of(stream.iterator());
    }

    public static Formula of(Iterator<? extends Formula> iterator) {
        HashSet<Formula> set = new HashSet<Formula>();
        while (iterator.hasNext()) {
            Formula child = iterator.next();
            assert (child != null);
            if (child == BooleanConstant.TRUE) {
                return BooleanConstant.TRUE;
            }
            if (child == BooleanConstant.FALSE) continue;
            if (child instanceof Disjunction) {
                set.addAll(((Disjunction)child).children);
                continue;
            }
            set.add(child);
        }
        if (set.isEmpty()) {
            return BooleanConstant.FALSE;
        }
        if (set.size() == 1) {
            return (Formula)set.iterator().next();
        }
        return new Disjunction(set);
    }

    @Override
    public int accept(IntVisitor v) {
        return v.visit(this);
    }

    @Override
    public <R> R accept(Visitor<R> v) {
        return v.visit(this);
    }

    public <A, B> A accept(BinaryVisitor<B, A> v, B parameter) {
        return v.visit(this, parameter);
    }

    @Override
    protected char getOperator() {
        return '|';
    }

    @Override
    protected int hashCodeOnce() {
        return Objects.hash(Disjunction.class, this.children);
    }

    @Override
    public Formula nnf() {
        return new Disjunction(this.map(Formula::nnf));
    }

    @Override
    public Formula not() {
        return new Conjunction(this.map(Formula::not));
    }

    @Override
    public Formula temporalStep(BitSet valuation) {
        return Disjunction.of(this.map(c -> c.temporalStep(valuation)));
    }

    @Override
    public Formula temporalStepUnfold(BitSet valuation) {
        return Disjunction.of(this.map(c -> c.temporalStepUnfold(valuation)));
    }

    @Override
    public Formula unfold() {
        return Disjunction.of(this.map(Formula::unfold));
    }

    @Override
    public Formula unfoldTemporalStep(BitSet valuation) {
        return Disjunction.of(this.map(c -> c.unfoldTemporalStep(valuation)));
    }
}

