/*
 * Decompiled with CFR 0.152.
 */
package owl.ltl;

import java.util.BitSet;
import owl.ltl.Biconditional;
import owl.ltl.BooleanConstant;
import owl.ltl.Conjunction;
import owl.ltl.Disjunction;
import owl.ltl.Formula;
import owl.ltl.GOperator;
import owl.ltl.MOperator;
import owl.ltl.UOperator;
import owl.ltl.UnaryModalOperator;
import owl.ltl.WOperator;
import owl.ltl.visitors.BinaryVisitor;
import owl.ltl.visitors.IntVisitor;
import owl.ltl.visitors.Visitor;

public class FOperator
extends UnaryModalOperator {
    public FOperator(Formula f) {
        super(f);
    }

    public static Formula of(Formula operand) {
        if (operand instanceof BooleanConstant) {
            return operand;
        }
        if (operand instanceof Disjunction) {
            return Disjunction.of(((Disjunction)operand).map(FOperator::of));
        }
        if (operand instanceof Biconditional) {
            Biconditional biconditional = (Biconditional)operand;
            return Disjunction.of(FOperator.of(Conjunction.of(biconditional.left, biconditional.right)), FOperator.of(Conjunction.of(biconditional.left.not(), biconditional.right.not())));
        }
        if (operand instanceof FOperator) {
            return operand;
        }
        if (operand instanceof MOperator) {
            MOperator mOperator = (MOperator)operand;
            return FOperator.of(Conjunction.of(mOperator.left, mOperator.right));
        }
        if (operand instanceof UOperator) {
            return FOperator.of(((UOperator)operand).right);
        }
        if (operand instanceof WOperator) {
            WOperator wOperator = (WOperator)operand;
            return Disjunction.of(FOperator.of(GOperator.of(wOperator.left)), FOperator.of(wOperator.right));
        }
        return new FOperator(operand);
    }

    @Override
    public int accept(IntVisitor v) {
        return v.visit(this);
    }

    @Override
    public <R> R accept(Visitor<R> v) {
        return v.visit(this);
    }

    public <A, B> A accept(BinaryVisitor<B, A> v, B parameter) {
        return v.visit(this, parameter);
    }

    @Override
    public String getOperator() {
        return "F";
    }

    @Override
    public boolean isPureEventual() {
        return true;
    }

    @Override
    public boolean isPureUniversal() {
        return this.operand.isPureUniversal();
    }

    @Override
    public boolean isSuspendable() {
        return this.operand.isPureUniversal() || this.operand.isSuspendable();
    }

    @Override
    public Formula nnf() {
        return FOperator.of(this.operand.nnf());
    }

    @Override
    public Formula not() {
        return GOperator.of(this.operand.not());
    }

    @Override
    public Formula unfold() {
        return Disjunction.of(this.operand.unfold(), (Formula)this);
    }

    @Override
    public Formula unfoldTemporalStep(BitSet valuation) {
        return Disjunction.of(this.operand.unfoldTemporalStep(valuation), (Formula)this);
    }
}

