/*
 * Decompiled with CFR 0.152.
 */
package owl.ltl.tlsf;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;
import owl.ltl.Formula;
import owl.ltl.LabelledFormula;
import owl.ltl.tlsf.Tlsf;

@ParametersAreNonnullByDefault
@Generated(from="Tlsf", generator="Immutables")
@CheckReturnValue
@Immutable
public final class ImmutableTlsf
extends Tlsf {
    private final ImmutableList<Formula> assert_;
    private final Formula assume;
    private final String description;
    private final ImmutableList<Formula> guarantee;
    private final Formula initially;
    private final BitSet inputs;
    private final BitSet outputs;
    private final ImmutableList<String> variables;
    private final Formula preset;
    private final Formula require;
    private final Tlsf.Semantics semantics;
    private final Tlsf.Semantics target;
    private final String title;
    private final transient int numberOfInputs;
    private final transient LabelledFormula toFormula;
    private final transient List<LabelledFormula> toAssertGuaranteeConjuncts;
    private static final byte STAGE_INITIALIZING = -1;
    private static final byte STAGE_UNINITIALIZED = 0;
    private static final byte STAGE_INITIALIZED = 1;
    private volatile transient InitShim initShim = new InitShim();

    private ImmutableTlsf(Builder builder) {
        this.description = builder.description;
        this.inputs = builder.inputs;
        this.outputs = builder.outputs;
        this.variables = builder.variables.build();
        this.semantics = builder.semantics;
        this.target = builder.target;
        this.title = builder.title;
        if (builder.assert_IsSet()) {
            this.initShim.assert_((ImmutableList<Formula>)builder.assert_.build());
        }
        if (builder.assume != null) {
            this.initShim.assume(builder.assume);
        }
        if (builder.guaranteeIsSet()) {
            this.initShim.guarantee((ImmutableList<Formula>)builder.guarantee.build());
        }
        if (builder.initially != null) {
            this.initShim.initially(builder.initially);
        }
        if (builder.preset != null) {
            this.initShim.preset(builder.preset);
        }
        if (builder.require != null) {
            this.initShim.require(builder.require);
        }
        this.assert_ = this.initShim.assert_();
        this.assume = this.initShim.assume();
        this.guarantee = this.initShim.guarantee();
        this.initially = this.initShim.initially();
        this.preset = this.initShim.preset();
        this.require = this.initShim.require();
        this.numberOfInputs = this.initShim.numberOfInputs();
        this.toFormula = this.initShim.toFormula();
        this.toAssertGuaranteeConjuncts = this.initShim.toAssertGuaranteeConjuncts();
        this.initShim = null;
    }

    private ImmutableTlsf(ImmutableList<Formula> assert_, Formula assume, String description, ImmutableList<Formula> guarantee, Formula initially, BitSet inputs, BitSet outputs, ImmutableList<String> variables, Formula preset, Formula require, Tlsf.Semantics semantics, Tlsf.Semantics target, String title) {
        this.initShim.assert_(assert_);
        this.initShim.assume(assume);
        this.description = description;
        this.initShim.guarantee(guarantee);
        this.initShim.initially(initially);
        this.inputs = inputs;
        this.outputs = outputs;
        this.variables = variables;
        this.initShim.preset(preset);
        this.initShim.require(require);
        this.semantics = semantics;
        this.target = target;
        this.title = title;
        this.assert_ = this.initShim.assert_();
        this.assume = this.initShim.assume();
        this.guarantee = this.initShim.guarantee();
        this.initially = this.initShim.initially();
        this.preset = this.initShim.preset();
        this.require = this.initShim.require();
        this.numberOfInputs = this.initShim.numberOfInputs();
        this.toFormula = this.initShim.toFormula();
        this.toAssertGuaranteeConjuncts = this.initShim.toAssertGuaranteeConjuncts();
        this.initShim = null;
    }

    public ImmutableList<Formula> assert_() {
        InitShim shim = this.initShim;
        return shim != null ? shim.assert_() : this.assert_;
    }

    @Override
    public Formula assume() {
        InitShim shim = this.initShim;
        return shim != null ? shim.assume() : this.assume;
    }

    @Override
    public String description() {
        return this.description;
    }

    public ImmutableList<Formula> guarantee() {
        InitShim shim = this.initShim;
        return shim != null ? shim.guarantee() : this.guarantee;
    }

    @Override
    public Formula initially() {
        InitShim shim = this.initShim;
        return shim != null ? shim.initially() : this.initially;
    }

    @Override
    public BitSet inputs() {
        return this.inputs;
    }

    @Override
    public BitSet outputs() {
        return this.outputs;
    }

    public ImmutableList<String> variables() {
        return this.variables;
    }

    @Override
    public Formula preset() {
        InitShim shim = this.initShim;
        return shim != null ? shim.preset() : this.preset;
    }

    @Override
    public Formula require() {
        InitShim shim = this.initShim;
        return shim != null ? shim.require() : this.require;
    }

    @Override
    public Tlsf.Semantics semantics() {
        return this.semantics;
    }

    @Override
    public Tlsf.Semantics target() {
        return this.target;
    }

    @Override
    public String title() {
        return this.title;
    }

    @Override
    public int numberOfInputs() {
        InitShim shim = this.initShim;
        return shim != null ? shim.numberOfInputs() : this.numberOfInputs;
    }

    @Override
    public LabelledFormula toFormula() {
        InitShim shim = this.initShim;
        return shim != null ? shim.toFormula() : this.toFormula;
    }

    @Override
    public List<LabelledFormula> toAssertGuaranteeConjuncts() {
        InitShim shim = this.initShim;
        return shim != null ? shim.toAssertGuaranteeConjuncts() : this.toAssertGuaranteeConjuncts;
    }

    public final ImmutableTlsf withAssert_(Formula ... elements) {
        ImmutableList newValue = ImmutableList.copyOf((Object[])elements);
        return ImmutableTlsf.validate(new ImmutableTlsf((ImmutableList<Formula>)newValue, this.assume, this.description, this.guarantee, this.initially, this.inputs, this.outputs, this.variables, this.preset, this.require, this.semantics, this.target, this.title));
    }

    public final ImmutableTlsf withAssert_(Iterable<? extends Formula> elements) {
        if (this.assert_ == elements) {
            return this;
        }
        ImmutableList newValue = ImmutableList.copyOf(elements);
        return ImmutableTlsf.validate(new ImmutableTlsf((ImmutableList<Formula>)newValue, this.assume, this.description, this.guarantee, this.initially, this.inputs, this.outputs, this.variables, this.preset, this.require, this.semantics, this.target, this.title));
    }

    public final ImmutableTlsf withAssume(Formula value) {
        if (this.assume == value) {
            return this;
        }
        Formula newValue = Objects.requireNonNull(value, "assume");
        return ImmutableTlsf.validate(new ImmutableTlsf(this.assert_, newValue, this.description, this.guarantee, this.initially, this.inputs, this.outputs, this.variables, this.preset, this.require, this.semantics, this.target, this.title));
    }

    public final ImmutableTlsf withDescription(String value) {
        if (this.description.equals(value)) {
            return this;
        }
        String newValue = Objects.requireNonNull(value, "description");
        return ImmutableTlsf.validate(new ImmutableTlsf(this.assert_, this.assume, newValue, this.guarantee, this.initially, this.inputs, this.outputs, this.variables, this.preset, this.require, this.semantics, this.target, this.title));
    }

    public final ImmutableTlsf withGuarantee(Formula ... elements) {
        ImmutableList newValue = ImmutableList.copyOf((Object[])elements);
        return ImmutableTlsf.validate(new ImmutableTlsf(this.assert_, this.assume, this.description, (ImmutableList<Formula>)newValue, this.initially, this.inputs, this.outputs, this.variables, this.preset, this.require, this.semantics, this.target, this.title));
    }

    public final ImmutableTlsf withGuarantee(Iterable<? extends Formula> elements) {
        if (this.guarantee == elements) {
            return this;
        }
        ImmutableList newValue = ImmutableList.copyOf(elements);
        return ImmutableTlsf.validate(new ImmutableTlsf(this.assert_, this.assume, this.description, (ImmutableList<Formula>)newValue, this.initially, this.inputs, this.outputs, this.variables, this.preset, this.require, this.semantics, this.target, this.title));
    }

    public final ImmutableTlsf withInitially(Formula value) {
        if (this.initially == value) {
            return this;
        }
        Formula newValue = Objects.requireNonNull(value, "initially");
        return ImmutableTlsf.validate(new ImmutableTlsf(this.assert_, this.assume, this.description, this.guarantee, newValue, this.inputs, this.outputs, this.variables, this.preset, this.require, this.semantics, this.target, this.title));
    }

    public final ImmutableTlsf withInputs(BitSet value) {
        if (this.inputs == value) {
            return this;
        }
        BitSet newValue = Objects.requireNonNull(value, "inputs");
        return ImmutableTlsf.validate(new ImmutableTlsf(this.assert_, this.assume, this.description, this.guarantee, this.initially, newValue, this.outputs, this.variables, this.preset, this.require, this.semantics, this.target, this.title));
    }

    public final ImmutableTlsf withOutputs(BitSet value) {
        if (this.outputs == value) {
            return this;
        }
        BitSet newValue = Objects.requireNonNull(value, "outputs");
        return ImmutableTlsf.validate(new ImmutableTlsf(this.assert_, this.assume, this.description, this.guarantee, this.initially, this.inputs, newValue, this.variables, this.preset, this.require, this.semantics, this.target, this.title));
    }

    public final ImmutableTlsf withVariables(String ... elements) {
        ImmutableList newValue = ImmutableList.copyOf((Object[])elements);
        return ImmutableTlsf.validate(new ImmutableTlsf(this.assert_, this.assume, this.description, this.guarantee, this.initially, this.inputs, this.outputs, (ImmutableList<String>)newValue, this.preset, this.require, this.semantics, this.target, this.title));
    }

    public final ImmutableTlsf withVariables(Iterable<String> elements) {
        if (this.variables == elements) {
            return this;
        }
        ImmutableList newValue = ImmutableList.copyOf(elements);
        return ImmutableTlsf.validate(new ImmutableTlsf(this.assert_, this.assume, this.description, this.guarantee, this.initially, this.inputs, this.outputs, (ImmutableList<String>)newValue, this.preset, this.require, this.semantics, this.target, this.title));
    }

    public final ImmutableTlsf withPreset(Formula value) {
        if (this.preset == value) {
            return this;
        }
        Formula newValue = Objects.requireNonNull(value, "preset");
        return ImmutableTlsf.validate(new ImmutableTlsf(this.assert_, this.assume, this.description, this.guarantee, this.initially, this.inputs, this.outputs, this.variables, newValue, this.require, this.semantics, this.target, this.title));
    }

    public final ImmutableTlsf withRequire(Formula value) {
        if (this.require == value) {
            return this;
        }
        Formula newValue = Objects.requireNonNull(value, "require");
        return ImmutableTlsf.validate(new ImmutableTlsf(this.assert_, this.assume, this.description, this.guarantee, this.initially, this.inputs, this.outputs, this.variables, this.preset, newValue, this.semantics, this.target, this.title));
    }

    public final ImmutableTlsf withSemantics(Tlsf.Semantics value) {
        if (this.semantics == value) {
            return this;
        }
        Tlsf.Semantics newValue = Objects.requireNonNull(value, "semantics");
        return ImmutableTlsf.validate(new ImmutableTlsf(this.assert_, this.assume, this.description, this.guarantee, this.initially, this.inputs, this.outputs, this.variables, this.preset, this.require, newValue, this.target, this.title));
    }

    public final ImmutableTlsf withTarget(Tlsf.Semantics value) {
        if (this.target == value) {
            return this;
        }
        Tlsf.Semantics newValue = Objects.requireNonNull(value, "target");
        return ImmutableTlsf.validate(new ImmutableTlsf(this.assert_, this.assume, this.description, this.guarantee, this.initially, this.inputs, this.outputs, this.variables, this.preset, this.require, this.semantics, newValue, this.title));
    }

    public final ImmutableTlsf withTitle(String value) {
        if (this.title.equals(value)) {
            return this;
        }
        String newValue = Objects.requireNonNull(value, "title");
        return ImmutableTlsf.validate(new ImmutableTlsf(this.assert_, this.assume, this.description, this.guarantee, this.initially, this.inputs, this.outputs, this.variables, this.preset, this.require, this.semantics, this.target, newValue));
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableTlsf && this.equalTo((ImmutableTlsf)another);
    }

    private boolean equalTo(ImmutableTlsf another) {
        return this.assert_.equals(another.assert_) && this.assume.equals(another.assume) && this.description.equals(another.description) && this.guarantee.equals(another.guarantee) && this.initially.equals(another.initially) && this.inputs.equals(another.inputs) && this.outputs.equals(another.outputs) && this.variables.equals(another.variables) && this.preset.equals(another.preset) && this.require.equals(another.require) && this.semantics.equals((Object)another.semantics) && this.target.equals((Object)another.target) && this.title.equals(another.title) && this.numberOfInputs == another.numberOfInputs && this.toFormula.equals(another.toFormula) && this.toAssertGuaranteeConjuncts.equals(another.toAssertGuaranteeConjuncts);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.assert_.hashCode();
        h += (h << 5) + this.assume.hashCode();
        h += (h << 5) + this.description.hashCode();
        h += (h << 5) + this.guarantee.hashCode();
        h += (h << 5) + this.initially.hashCode();
        h += (h << 5) + this.inputs.hashCode();
        h += (h << 5) + this.outputs.hashCode();
        h += (h << 5) + this.variables.hashCode();
        h += (h << 5) + this.preset.hashCode();
        h += (h << 5) + this.require.hashCode();
        h += (h << 5) + this.semantics.hashCode();
        h += (h << 5) + this.target.hashCode();
        h += (h << 5) + this.title.hashCode();
        h += (h << 5) + this.numberOfInputs;
        h += (h << 5) + this.toFormula.hashCode();
        h += (h << 5) + this.toAssertGuaranteeConjuncts.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"Tlsf").omitNullValues().add("assert_", this.assert_).add("assume", (Object)this.assume).add("description", (Object)this.description).add("guarantee", this.guarantee).add("initially", (Object)this.initially).add("inputs", (Object)this.inputs).add("outputs", (Object)this.outputs).add("variables", this.variables).add("preset", (Object)this.preset).add("require", (Object)this.require).add("semantics", (Object)this.semantics).add("target", (Object)this.target).add("title", (Object)this.title).add("numberOfInputs", this.numberOfInputs).add("toFormula", (Object)this.toFormula).add("toAssertGuaranteeConjuncts", this.toAssertGuaranteeConjuncts).toString();
    }

    private static ImmutableTlsf validate(ImmutableTlsf instance) {
        instance.check();
        return instance;
    }

    public static ImmutableTlsf copyOf(Tlsf instance) {
        if (instance instanceof ImmutableTlsf) {
            return (ImmutableTlsf)instance;
        }
        return ImmutableTlsf.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_DESCRIPTION = 1L;
        private static final long INIT_BIT_INPUTS = 2L;
        private static final long INIT_BIT_OUTPUTS = 4L;
        private static final long INIT_BIT_SEMANTICS = 8L;
        private static final long INIT_BIT_TARGET = 16L;
        private static final long INIT_BIT_TITLE = 32L;
        private static final long OPT_BIT_ASSERT_ = 1L;
        private static final long OPT_BIT_GUARANTEE = 2L;
        private long initBits = 63L;
        private long optBits;
        private ImmutableList.Builder<Formula> assert_ = ImmutableList.builder();
        @Nullable
        private Formula assume;
        @Nullable
        private String description;
        private ImmutableList.Builder<Formula> guarantee = ImmutableList.builder();
        @Nullable
        private Formula initially;
        @Nullable
        private BitSet inputs;
        @Nullable
        private BitSet outputs;
        private ImmutableList.Builder<String> variables = ImmutableList.builder();
        @Nullable
        private Formula preset;
        @Nullable
        private Formula require;
        @Nullable
        private Tlsf.Semantics semantics;
        @Nullable
        private Tlsf.Semantics target;
        @Nullable
        private String title;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(Tlsf instance) {
            Objects.requireNonNull(instance, "instance");
            this.addAllAssert_(instance.assert_());
            this.assume(instance.assume());
            this.description(instance.description());
            this.addAllGuarantee(instance.guarantee());
            this.initially(instance.initially());
            this.inputs(instance.inputs());
            this.outputs(instance.outputs());
            this.addAllVariables(instance.variables());
            this.preset(instance.preset());
            this.require(instance.require());
            this.semantics(instance.semantics());
            this.target(instance.target());
            this.title(instance.title());
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addAssert_(Formula element) {
            this.assert_.add((Object)element);
            this.optBits |= 1L;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addAssert_(Formula ... elements) {
            this.assert_.add((Object[])elements);
            this.optBits |= 1L;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder assert_(Iterable<? extends Formula> elements) {
            this.assert_ = ImmutableList.builder();
            return this.addAllAssert_(elements);
        }

        @CanIgnoreReturnValue
        public final Builder addAllAssert_(Iterable<? extends Formula> elements) {
            this.assert_.addAll(elements);
            this.optBits |= 1L;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder assume(Formula assume) {
            this.assume = Objects.requireNonNull(assume, "assume");
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder description(String description) {
            this.description = Objects.requireNonNull(description, "description");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addGuarantee(Formula element) {
            this.guarantee.add((Object)element);
            this.optBits |= 2L;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addGuarantee(Formula ... elements) {
            this.guarantee.add((Object[])elements);
            this.optBits |= 2L;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder guarantee(Iterable<? extends Formula> elements) {
            this.guarantee = ImmutableList.builder();
            return this.addAllGuarantee(elements);
        }

        @CanIgnoreReturnValue
        public final Builder addAllGuarantee(Iterable<? extends Formula> elements) {
            this.guarantee.addAll(elements);
            this.optBits |= 2L;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder initially(Formula initially) {
            this.initially = Objects.requireNonNull(initially, "initially");
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder inputs(BitSet inputs) {
            this.inputs = Objects.requireNonNull(inputs, "inputs");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder outputs(BitSet outputs) {
            this.outputs = Objects.requireNonNull(outputs, "outputs");
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addVariables(String element) {
            this.variables.add((Object)element);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addVariables(String ... elements) {
            this.variables.add((Object[])elements);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder variables(Iterable<String> elements) {
            this.variables = ImmutableList.builder();
            return this.addAllVariables(elements);
        }

        @CanIgnoreReturnValue
        public final Builder addAllVariables(Iterable<String> elements) {
            this.variables.addAll(elements);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder preset(Formula preset) {
            this.preset = Objects.requireNonNull(preset, "preset");
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder require(Formula require) {
            this.require = Objects.requireNonNull(require, "require");
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder semantics(Tlsf.Semantics semantics) {
            this.semantics = Objects.requireNonNull(semantics, "semantics");
            this.initBits &= 0xFFFFFFFFFFFFFFF7L;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder target(Tlsf.Semantics target) {
            this.target = Objects.requireNonNull(target, "target");
            this.initBits &= 0xFFFFFFFFFFFFFFEFL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder title(String title) {
            this.title = Objects.requireNonNull(title, "title");
            this.initBits &= 0xFFFFFFFFFFFFFFDFL;
            return this;
        }

        public ImmutableTlsf build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return ImmutableTlsf.validate(new ImmutableTlsf(this));
        }

        private boolean assert_IsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private boolean guaranteeIsSet() {
            return (this.optBits & 2L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("description");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("inputs");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("outputs");
            }
            if ((this.initBits & 8L) != 0L) {
                attributes.add("semantics");
            }
            if ((this.initBits & 0x10L) != 0L) {
                attributes.add("target");
            }
            if ((this.initBits & 0x20L) != 0L) {
                attributes.add("title");
            }
            return "Cannot build Tlsf, some of required attributes are not set " + attributes;
        }
    }

    private final class InitShim {
        private byte assert_BuildStage = 0;
        private ImmutableList<Formula> assert_;
        private byte assumeBuildStage = 0;
        private Formula assume;
        private byte guaranteeBuildStage = 0;
        private ImmutableList<Formula> guarantee;
        private byte initiallyBuildStage = 0;
        private Formula initially;
        private byte presetBuildStage = 0;
        private Formula preset;
        private byte requireBuildStage = 0;
        private Formula require;
        private byte numberOfInputsBuildStage = 0;
        private int numberOfInputs;
        private byte toFormulaBuildStage = 0;
        private LabelledFormula toFormula;
        private byte toAssertGuaranteeConjunctsBuildStage = 0;
        private List<LabelledFormula> toAssertGuaranteeConjuncts;

        private InitShim() {
        }

        ImmutableList<Formula> assert_() {
            if (this.assert_BuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.assert_BuildStage == 0) {
                this.assert_BuildStage = (byte)-1;
                this.assert_ = ImmutableList.copyOf((Collection)ImmutableTlsf.super.assert_());
                this.assert_BuildStage = 1;
            }
            return this.assert_;
        }

        void assert_(ImmutableList<Formula> assert_) {
            this.assert_ = assert_;
            this.assert_BuildStage = 1;
        }

        Formula assume() {
            if (this.assumeBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.assumeBuildStage == 0) {
                this.assumeBuildStage = (byte)-1;
                this.assume = Objects.requireNonNull(ImmutableTlsf.super.assume(), "assume");
                this.assumeBuildStage = 1;
            }
            return this.assume;
        }

        void assume(Formula assume) {
            this.assume = assume;
            this.assumeBuildStage = 1;
        }

        ImmutableList<Formula> guarantee() {
            if (this.guaranteeBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.guaranteeBuildStage == 0) {
                this.guaranteeBuildStage = (byte)-1;
                this.guarantee = ImmutableList.copyOf((Collection)ImmutableTlsf.super.guarantee());
                this.guaranteeBuildStage = 1;
            }
            return this.guarantee;
        }

        void guarantee(ImmutableList<Formula> guarantee) {
            this.guarantee = guarantee;
            this.guaranteeBuildStage = 1;
        }

        Formula initially() {
            if (this.initiallyBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.initiallyBuildStage == 0) {
                this.initiallyBuildStage = (byte)-1;
                this.initially = Objects.requireNonNull(ImmutableTlsf.super.initially(), "initially");
                this.initiallyBuildStage = 1;
            }
            return this.initially;
        }

        void initially(Formula initially) {
            this.initially = initially;
            this.initiallyBuildStage = 1;
        }

        Formula preset() {
            if (this.presetBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.presetBuildStage == 0) {
                this.presetBuildStage = (byte)-1;
                this.preset = Objects.requireNonNull(ImmutableTlsf.super.preset(), "preset");
                this.presetBuildStage = 1;
            }
            return this.preset;
        }

        void preset(Formula preset) {
            this.preset = preset;
            this.presetBuildStage = 1;
        }

        Formula require() {
            if (this.requireBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.requireBuildStage == 0) {
                this.requireBuildStage = (byte)-1;
                this.require = Objects.requireNonNull(ImmutableTlsf.super.require(), "require");
                this.requireBuildStage = 1;
            }
            return this.require;
        }

        void require(Formula require) {
            this.require = require;
            this.requireBuildStage = 1;
        }

        int numberOfInputs() {
            if (this.numberOfInputsBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.numberOfInputsBuildStage == 0) {
                this.numberOfInputsBuildStage = (byte)-1;
                this.numberOfInputs = ImmutableTlsf.super.numberOfInputs();
                this.numberOfInputsBuildStage = 1;
            }
            return this.numberOfInputs;
        }

        LabelledFormula toFormula() {
            if (this.toFormulaBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.toFormulaBuildStage == 0) {
                this.toFormulaBuildStage = (byte)-1;
                this.toFormula = Objects.requireNonNull(ImmutableTlsf.super.toFormula(), "toFormula");
                this.toFormulaBuildStage = 1;
            }
            return this.toFormula;
        }

        List<LabelledFormula> toAssertGuaranteeConjuncts() {
            if (this.toAssertGuaranteeConjunctsBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.toAssertGuaranteeConjunctsBuildStage == 0) {
                this.toAssertGuaranteeConjunctsBuildStage = (byte)-1;
                this.toAssertGuaranteeConjuncts = Objects.requireNonNull(ImmutableTlsf.super.toAssertGuaranteeConjuncts(), "toAssertGuaranteeConjuncts");
                this.toAssertGuaranteeConjunctsBuildStage = 1;
            }
            return this.toAssertGuaranteeConjuncts;
        }

        private String formatInitCycleMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (this.assert_BuildStage == -1) {
                attributes.add("assert_");
            }
            if (this.assumeBuildStage == -1) {
                attributes.add("assume");
            }
            if (this.guaranteeBuildStage == -1) {
                attributes.add("guarantee");
            }
            if (this.initiallyBuildStage == -1) {
                attributes.add("initially");
            }
            if (this.presetBuildStage == -1) {
                attributes.add("preset");
            }
            if (this.requireBuildStage == -1) {
                attributes.add("require");
            }
            if (this.numberOfInputsBuildStage == -1) {
                attributes.add("numberOfInputs");
            }
            if (this.toFormulaBuildStage == -1) {
                attributes.add("toFormula");
            }
            if (this.toAssertGuaranteeConjunctsBuildStage == -1) {
                attributes.add("toAssertGuaranteeConjuncts");
            }
            return "Cannot build Tlsf, attribute initializers form cycle " + attributes;
        }
    }
}

