/*
 * Decompiled with CFR 0.152.
 */
package owl.run.modules;

import com.google.common.base.Preconditions;
import java.io.IOException;
import java.io.Writer;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import jhoafparser.consumer.HOAConsumer;
import jhoafparser.consumer.HOAConsumerPrint;
import jhoafparser.consumer.HOAIntermediateStoreAndManipulate;
import jhoafparser.storage.StoredAutomatonManipulator;
import jhoafparser.transformations.ToStateAcceptance;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import owl.automaton.Automaton;
import owl.automaton.acceptance.OmegaAcceptance;
import owl.automaton.algorithms.SccDecomposition;
import owl.automaton.output.HoaPrinter;
import owl.run.Environment;
import owl.run.modules.ImmutableWriterParser;
import owl.run.modules.OutputWriter;
import owl.run.modules.OwlModuleParser;

public final class OutputWriters {
    public static final OwlModuleParser.WriterParser AUTOMATON_STATS_CLI = ImmutableWriterParser.builder().key("aut-stat").description("Writes several stats of a given automaton to the given format string").optionsBuilder(() -> {
        Option format = new Option("f", "format", true, "The format string. Uses a reduced set of the spot syntax\n%A, %a   Number of acceptance sets\n%C, %c   Number of SCCs\n%D, %d   1 if the automaton is deterministic, 0 otherwise\n%G, %g   acceptance condition (in HOA syntax)\n%S, %s   Number of states\n%H, %h   The automaton in HOA format on a single line\n%M, %m   Name of the automaton\n%n       Newline\n%X, %x   Number of atomic propositions");
        format.setRequired(true);
        return new Options().addOption(format);
    }).parser(settings -> OutputWriters.automatonStats(settings.getOptionValue("format"))).build();
    public static final OwlModuleParser.WriterParser HOA_CLI = ImmutableWriterParser.builder().key("hoa").description("Writes the HOA format representation of an automaton or an game").parser(settings -> {
        List<Object> manipulators = settings.hasOption("state-acceptance") ? List.of(new ToStateAcceptance()) : List.of();
        EnumSet<ToHoa.Setting> hoaSettings = EnumSet.noneOf(ToHoa.Setting.class);
        if (settings.hasOption("simple-trans")) {
            hoaSettings.add(ToHoa.Setting.SIMPLE_TRANSITION_LABELS);
        }
        return new ToHoa(hoaSettings, manipulators);
    }).build();
    public static final OutputWriter NULL = (writer, environment) -> object -> writer.flush();
    public static final OwlModuleParser.WriterParser NULL_CLI = ImmutableWriterParser.builder().key("null").description("Discards the output - useful for performance testing").parser(settings -> NULL).build();
    public static final OutputWriter TO_STRING = (writer, environment) -> object -> {
        writer.write(object.toString());
        writer.write(System.lineSeparator());
    };
    public static final OwlModuleParser.WriterParser TO_STRING_CLI = ImmutableWriterParser.builder().key("string").description("Prints the toString() representation of all passed objects").parser(settings -> TO_STRING).build();
    public static final OutputWriter HOA = ToHoa.DEFAULT;

    private OutputWriters() {
    }

    public static OutputWriter automatonStats(String format) {
        return (writer, environment) -> new AutomatonStats(format, writer)::write;
    }

    public static class ToHoa
    implements OutputWriter {
        public static final ToHoa DEFAULT = new ToHoa(EnumSet.noneOf(Setting.class), List.of());
        private static final StoredAutomatonManipulator[] EMPTY = new StoredAutomatonManipulator[0];
        private final Set<Setting> hoaSettings;
        private final List<StoredAutomatonManipulator> operations;

        public ToHoa(EnumSet<Setting> hoaSettings, List<StoredAutomatonManipulator> operations) {
            this.hoaSettings = Set.copyOf(hoaSettings);
            this.operations = List.copyOf(operations);
        }

        @Override
        public OutputWriter.Binding bind(Writer writer, Environment environment) {
            HOAConsumerPrint consumer = this.operations.isEmpty() ? new HOAConsumerPrint(writer) : new HOAIntermediateStoreAndManipulate((HOAConsumer)new HOAConsumerPrint(writer), this.operations.toArray(EMPTY));
            EnumSet<HoaPrinter.HoaOption> options = EnumSet.noneOf(HoaPrinter.HoaOption.class);
            if (environment.annotations()) {
                options.add(HoaPrinter.HoaOption.ANNOTATIONS);
            }
            if (this.hoaSettings.contains((Object)Setting.SIMPLE_TRANSITION_LABELS)) {
                options.add(HoaPrinter.HoaOption.SIMPLE_TRANSITION_LABELS);
            }
            return arg_0 -> ToHoa.lambda$bind$0((HOAConsumer)consumer, options, arg_0);
        }

        private static /* synthetic */ void lambda$bind$0(HOAConsumer consumer, EnumSet options, Object input) throws Exception {
            HoaPrinter.feedTo(input, consumer, (EnumSet<HoaPrinter.HoaOption>)options);
        }

        public static enum Setting {
            SIMPLE_TRANSITION_LABELS;

        }
    }

    public static class AutomatonStats {
        private static final Map<Pattern, Function<Automaton<?, ?>, String>> patterns = Map.of(Pattern.compile("%G", 18), automaton -> ((OmegaAcceptance)automaton.acceptance()).booleanExpression().toString(), Pattern.compile("%A", 18), automaton -> String.valueOf(((OmegaAcceptance)automaton.acceptance()).acceptanceSets()), Pattern.compile("%D", 18), automaton -> automaton.is(Automaton.Property.DETERMINISTIC) ? "1" : "0", Pattern.compile("%H", 18), automaton -> HoaPrinter.toString(automaton).replace('\n', ' '), Pattern.compile("%M", 18), Automaton::name, Pattern.compile("%S", 18), automaton -> String.valueOf(automaton.size()), Pattern.compile("%X", 18), automaton -> String.valueOf(automaton.factory().alphabet().size()), Pattern.compile("%C", 18), automaton -> String.valueOf(SccDecomposition.computeSccs(automaton).size()), Pattern.compile("%n", 16), automaton -> "\n");
        private final String formatString;
        private final Writer writer;

        public AutomatonStats(String formatString, Writer writer) {
            this.formatString = formatString;
            this.writer = writer;
        }

        void write(Object object) throws IOException {
            Preconditions.checkArgument((boolean)(object instanceof Automaton));
            Automaton automaton = (Automaton)object;
            String result = this.formatString;
            for (Map.Entry<Pattern, Function<Automaton<?, ?>, String>> pattern : patterns.entrySet()) {
                Matcher matcher = pattern.getKey().matcher(result);
                if (!matcher.find()) continue;
                String replacement = Matcher.quoteReplacement(pattern.getValue().apply(automaton));
                result = matcher.replaceAll(replacement);
            }
            this.writer.write(result);
        }
    }
}

