/*
 * Decompiled with CFR 0.152.
 */
package owl.translations.delag;

import com.google.common.collect.Iterables;
import it.unimi.dsi.fastutil.longs.LongArrays;
import java.util.BitSet;
import java.util.List;
import java.util.Optional;
import java.util.function.Supplier;
import java.util.stream.Stream;
import javax.annotation.Nonnegative;
import javax.annotation.Nullable;
import jhoafparser.ast.Atom;
import jhoafparser.ast.AtomAcceptance;
import jhoafparser.ast.BooleanExpression;
import owl.automaton.Automaton;
import owl.automaton.acceptance.OmegaAcceptance;
import owl.automaton.edge.Edge;
import owl.ltl.EquivalenceClass;
import owl.ltl.Formula;
import owl.ltl.SyntacticFragment;
import owl.ltl.SyntacticFragments;
import owl.ltl.UnaryModalOperator;
import owl.ltl.visitors.PrintVisitor;
import owl.ltl.visitors.XDepthVisitor;
import owl.translations.delag.ProductState;
import owl.translations.delag.RequiredHistory;
import owl.translations.delag.SatisfactionRelation;
import owl.translations.delag.State;

abstract class DependencyTree<T> {
    DependencyTree() {
    }

    static <T> DependencyTree<T> createAnd(List<DependencyTree<T>> children) {
        if (children.size() == 1) {
            return (DependencyTree)Iterables.getOnlyElement(children);
        }
        return new And<T>(children);
    }

    static <T> Leaf<T> createLeaf(Formula formula, @Nonnegative int acceptanceSet, Supplier<Automaton<T, ?>> fallback, @Nullable AtomAcceptance piggyback) {
        if (SyntacticFragment.CO_SAFETY.contains(formula)) {
            if (piggyback == null) {
                return new Leaf(formula, Type.CO_SAFETY, acceptanceSet);
            }
            return new Leaf(formula, Type.CO_SAFETY, piggyback);
        }
        if (SyntacticFragment.SAFETY.contains(formula)) {
            if (piggyback == null) {
                return new Leaf(formula, Type.SAFETY, acceptanceSet);
            }
            return new Leaf(formula, Type.SAFETY, piggyback);
        }
        if (SyntacticFragment.FGX.contains(formula)) {
            if (SyntacticFragments.isAlmostAll(formula)) {
                return new Leaf(formula, Type.LIMIT_FG, acceptanceSet);
            }
            if (SyntacticFragments.isInfinitelyOften(formula)) {
                return new Leaf(formula, Type.LIMIT_GF, acceptanceSet);
            }
        }
        return new FallbackLeaf<T>(formula, acceptanceSet, fallback.get());
    }

    static <T> DependencyTree<T> createOr(List<DependencyTree<T>> children) {
        if (children.size() == 1) {
            return (DependencyTree)Iterables.getOnlyElement(children);
        }
        return new Or<T>(children);
    }

    static long[] unionTail(long[] history1, long[] history2) {
        if (history1.length < history2.length) {
            return DependencyTree.unionTail(history2, history1);
        }
        int offset = history1.length - history2.length;
        for (int i = history2.length - 1; 0 <= i; --i) {
            int n = offset + i;
            history1[n] = history1[n] | history2[i];
        }
        return history1;
    }

    static Formula unwrap(Formula formula) {
        return ((UnaryModalOperator)((UnaryModalOperator)formula).operand).operand;
    }

    @Nullable
    abstract Boolean buildSuccessor(State<T> var1, BitSet var2, ProductState.Builder<T> var3);

    abstract BitSet getAcceptance(State<T> var1, BitSet var2, @Nullable Boolean var3);

    abstract BooleanExpression<AtomAcceptance> getAcceptanceExpression();

    abstract long[] getRequiredHistory(ProductState<T> var1);

    static class Or<T>
    extends Node<T> {
        Or(List<DependencyTree<T>> children) {
            super(children);
        }

        @Override
        BooleanExpression<AtomAcceptance> getAcceptanceExpression() {
            return this.getAcceptanceExpressionStream().distinct().reduce(BooleanExpression::or).orElse((BooleanExpression<AtomAcceptance>)new BooleanExpression(false));
        }

        @Override
        boolean shortCircuit(boolean value) {
            return value;
        }

        @Override
        boolean suspend(ProductState<T> productState, Leaf<T> leaf) {
            return productState.safety().containsKey(leaf.formula) && (SyntacticFragment.FINITE.contains(leaf.formula) || leaf.type == Type.SAFETY);
        }

        public String toString() {
            if (this.children.isEmpty()) {
                return "ff";
            }
            return String.join((CharSequence)" | ", () -> this.children.stream().map(child -> child.toString()).iterator());
        }
    }

    static abstract class Node<T>
    extends DependencyTree<T> {
        final List<DependencyTree<T>> children;

        Node(List<DependencyTree<T>> children) {
            this.children = List.copyOf(children);
        }

        @Override
        Boolean buildSuccessor(State<T> state, BitSet valuation, ProductState.Builder<T> builder) {
            if (state.productState.finished().containsKey(this)) {
                builder.addFinished(this, state.productState.finished().get(this));
                return state.productState.finished().get(this);
            }
            ProductState.Builder childBuilder = new ProductState.Builder();
            Optional<Object> consensus = null;
            for (DependencyTree<T> child : this.children) {
                Boolean result = child.buildSuccessor(state, valuation, childBuilder);
                if (result != null && this.shortCircuit(result)) {
                    builder.addFinished(this, result);
                    return result;
                }
                if (result == null) {
                    consensus = Optional.empty();
                    continue;
                }
                if (consensus == null) {
                    consensus = Optional.of(result);
                    continue;
                }
                if (!consensus.isPresent()) continue;
                consensus = ((Boolean)consensus.get()).equals(result) ? consensus : Optional.empty();
            }
            assert (consensus != null) : "Children list was empty!";
            if (consensus.isPresent()) {
                builder.addFinished(this, (Boolean)consensus.get());
                return (Boolean)consensus.get();
            }
            builder.merge(childBuilder);
            return null;
        }

        @Override
        BitSet getAcceptance(State<T> state, BitSet valuation, @Nullable Boolean parentAcceptance) {
            Boolean acceptance = parentAcceptance == null ? state.productState.finished().get(this) : parentAcceptance;
            BitSet set = new BitSet();
            BitSet fairnessSet = new BitSet();
            for (DependencyTree<T> child : this.children) {
                if (child instanceof Leaf) {
                    if (this.suspend(state.productState, (Leaf)child)) {
                        fairnessSet = null;
                    }
                    if (fairnessSet != null && (((Leaf)child).type == Type.LIMIT_FG || ((Leaf)child).type == Type.LIMIT_GF)) {
                        fairnessSet.or(child.getAcceptance(state, valuation, acceptance));
                    }
                    if (((Leaf)child).type != Type.SAFETY && ((Leaf)child).type != Type.CO_SAFETY && ((Leaf)child).type != Type.FALLBACK) continue;
                    set.or(child.getAcceptance(state, valuation, acceptance));
                    continue;
                }
                set.or(child.getAcceptance(state, valuation, acceptance));
            }
            if (fairnessSet != null) {
                set.or(fairnessSet);
            }
            return set;
        }

        Stream<BooleanExpression<AtomAcceptance>> getAcceptanceExpressionStream() {
            return this.children.stream().map(DependencyTree::getAcceptanceExpression);
        }

        @Override
        long[] getRequiredHistory(ProductState<T> successor) {
            long[] requiredHistory = LongArrays.EMPTY_ARRAY;
            if (successor.finished().containsKey(this)) {
                return requiredHistory;
            }
            for (DependencyTree<T> child : this.children) {
                if (child instanceof Leaf && this.suspend(successor, (Leaf)child)) {
                    return LongArrays.EMPTY_ARRAY;
                }
                requiredHistory = Node.unionTail(requiredHistory, child.getRequiredHistory(successor));
            }
            return requiredHistory;
        }

        abstract boolean shortCircuit(boolean var1);

        abstract boolean suspend(ProductState<T> var1, Leaf<T> var2);
    }

    static class Leaf<T>
    extends DependencyTree<T> {
        final AtomAcceptance acceptance;
        final Formula formula;
        final Type type;

        Leaf(Formula formula, Type type, int acceptanceSet) {
            this.formula = formula;
            this.type = type;
            this.acceptance = type == Type.LIMIT_GF || type == Type.SAFETY ? AtomAcceptance.Inf((int)acceptanceSet) : AtomAcceptance.Fin((int)acceptanceSet);
        }

        Leaf(Formula formula, Type type, AtomAcceptance piggyback) {
            assert (type == Type.CO_SAFETY || type == Type.SAFETY);
            this.formula = formula;
            this.type = type;
            this.acceptance = piggyback;
        }

        @Override
        Boolean buildSuccessor(State<T> state, BitSet valuation, ProductState.Builder<T> builder) {
            Boolean value = state.productState.finished().get(this);
            if (value != null) {
                builder.addFinished(this, value);
                return value;
            }
            if (this.type == Type.SAFETY || this.type == Type.CO_SAFETY) {
                EquivalenceClass successor = state.productState.safety().get(this.formula).temporalStepUnfold(valuation);
                if (successor.isFalse()) {
                    builder.addFinished(this, Boolean.FALSE);
                    return Boolean.FALSE;
                }
                if (successor.isTrue()) {
                    builder.addFinished(this, Boolean.TRUE);
                    return Boolean.TRUE;
                }
                builder.addSafety(this.formula, successor);
                return null;
            }
            return null;
        }

        @Override
        BitSet getAcceptance(State<T> state, BitSet valuation, @Nullable Boolean parentAcceptance) {
            BitSet set = new BitSet();
            boolean inSet = false;
            switch (this.type) {
                case CO_SAFETY: {
                    if (this.acceptance.getType() != AtomAcceptance.Type.TEMPORAL_FIN) break;
                    Boolean value = state.productState.finished().get(this);
                    inSet = value == null || value == false;
                    break;
                }
                case SAFETY: {
                    if (this.acceptance.getType() != AtomAcceptance.Type.TEMPORAL_INF) break;
                    Boolean value = state.productState.finished().get(this);
                    inSet = value == null || value != false;
                    break;
                }
                case LIMIT_GF: {
                    Formula unwrapped = Leaf.unwrap(this.formula);
                    inSet = SatisfactionRelation.models(state.past, valuation, unwrapped);
                    break;
                }
                case LIMIT_FG: {
                    Formula unwrapped = Leaf.unwrap(this.formula);
                    inSet = !SatisfactionRelation.models(state.past, valuation, unwrapped);
                    break;
                }
                default: {
                    assert (false);
                    break;
                }
            }
            if (parentAcceptance != null) {
                if (this.acceptance.getType() == AtomAcceptance.Type.TEMPORAL_INF) {
                    inSet = parentAcceptance;
                } else {
                    boolean bl = inSet = parentAcceptance == false;
                }
            }
            if (inSet) {
                set.set(this.acceptance.getAcceptanceSet());
            }
            return set;
        }

        @Override
        BooleanExpression<AtomAcceptance> getAcceptanceExpression() {
            return new BooleanExpression((Atom)this.acceptance);
        }

        @Override
        long[] getRequiredHistory(ProductState<T> successor) {
            if (this.type == Type.CO_SAFETY || this.type == Type.SAFETY || XDepthVisitor.getDepth(this.formula) == 0) {
                return LongArrays.EMPTY_ARRAY;
            }
            return RequiredHistory.getRequiredHistory(Leaf.unwrap(this.formula));
        }
    }

    static class FallbackLeaf<T>
    extends Leaf<T> {
        final int acceptanceSet;
        final Automaton<T, ?> automaton;

        FallbackLeaf(Formula formula, int acceptanceSet, Automaton<T, ?> automaton) {
            super(formula, Type.FALLBACK, -1);
            assert (automaton.is(Automaton.Property.DETERMINISTIC));
            this.acceptanceSet = acceptanceSet;
            this.automaton = automaton;
        }

        @Override
        Boolean buildSuccessor(State<T> state, BitSet valuation, ProductState.Builder<T> builder) {
            Object fallbackState = state.productState.fallback().get(this.formula);
            if (fallbackState == null) {
                builder.addFinished(this, Boolean.FALSE);
                return Boolean.FALSE;
            }
            Edge<T> edge = this.automaton.edge(fallbackState, valuation);
            if (edge == null) {
                builder.addFinished(this, Boolean.FALSE);
                return Boolean.FALSE;
            }
            builder.addFallback(this.formula, edge.successor());
            return null;
        }

        @Override
        BitSet getAcceptance(State<T> state, BitSet valuation, @Nullable Boolean parentAcceptance) {
            Edge edge = this.getEdge(state.productState, valuation);
            BitSet set = new BitSet();
            if (edge != null) {
                edge.acceptanceSetIterator().forEachRemaining(x -> set.set(x + this.acceptanceSet));
            }
            return set;
        }

        @Override
        BooleanExpression<AtomAcceptance> getAcceptanceExpression() {
            return this.shift(((OmegaAcceptance)this.automaton.acceptance()).booleanExpression());
        }

        @Nullable
        private Edge<T> getEdge(ProductState<T> state, BitSet valuation) {
            T stateT = state.fallback().get(this.formula);
            if (stateT == null) {
                return null;
            }
            return this.automaton.edge(stateT, valuation);
        }

        @Override
        long[] getRequiredHistory(ProductState<T> successor) {
            return LongArrays.EMPTY_ARRAY;
        }

        private BooleanExpression<AtomAcceptance> shift(BooleanExpression<AtomAcceptance> expression) {
            switch (expression.getType()) {
                case EXP_AND: {
                    return this.shift((BooleanExpression<AtomAcceptance>)expression.getLeft()).and(this.shift((BooleanExpression<AtomAcceptance>)expression.getRight()));
                }
                case EXP_OR: {
                    return this.shift((BooleanExpression<AtomAcceptance>)expression.getLeft()).or(this.shift((BooleanExpression<AtomAcceptance>)expression.getRight()));
                }
                case EXP_NOT: {
                    return this.shift((BooleanExpression<AtomAcceptance>)expression.getLeft()).not();
                }
                case EXP_TRUE: 
                case EXP_FALSE: {
                    return expression;
                }
                case EXP_ATOM: {
                    return new BooleanExpression((Atom)this.shift((AtomAcceptance)expression.getAtom()));
                }
            }
            throw new AssertionError((Object)"Unreachable");
        }

        private AtomAcceptance shift(AtomAcceptance atom) {
            return new AtomAcceptance(atom.getType(), Integer.valueOf(atom.getAcceptanceSet() + this.acceptanceSet), atom.isNegated());
        }

        public String toString() {
            return String.format("Fallback{%s, %s %d}", PrintVisitor.toString(this.formula, this.automaton.factory().alphabet()), this.acceptance, this.acceptanceSet);
        }
    }

    static class And<T>
    extends Node<T> {
        And(List<DependencyTree<T>> children) {
            super(children);
        }

        @Override
        BooleanExpression<AtomAcceptance> getAcceptanceExpression() {
            return this.getAcceptanceExpressionStream().distinct().reduce(BooleanExpression::and).orElse((BooleanExpression<AtomAcceptance>)new BooleanExpression(true));
        }

        @Override
        boolean shortCircuit(boolean value) {
            return !value;
        }

        @Override
        boolean suspend(ProductState<T> productState, Leaf<T> leaf) {
            return productState.safety().containsKey(leaf.formula) && (SyntacticFragment.FINITE.contains(leaf.formula) || leaf.type == Type.CO_SAFETY);
        }

        public String toString() {
            if (this.children.isEmpty()) {
                return "tt";
            }
            return String.join((CharSequence)" & ", () -> this.children.stream().map(child -> child.toString()).iterator());
        }
    }

    static enum Type {
        SAFETY,
        CO_SAFETY,
        LIMIT_FG,
        LIMIT_GF,
        FALLBACK;

    }
}

