/*
 * Decompiled with CFR 0.152.
 */
package owl.translations.ldba2dpa;

import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.function.Predicate;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Nullable;
import owl.automaton.Automaton;
import owl.automaton.AutomatonFactory;
import owl.automaton.acceptance.BuchiAcceptance;
import owl.automaton.acceptance.ParityAcceptance;
import owl.automaton.edge.Edge;
import owl.automaton.ldba.LimitDeterministicAutomaton;
import owl.translations.ldba2dpa.AbstractBuilder;
import owl.translations.ldba2dpa.FlatRankingState;
import owl.translations.ldba2dpa.Language;
import owl.translations.ldba2dpa.LanguageLattice;

public final class FlatRankingAutomaton {
    private FlatRankingAutomaton() {
    }

    public static <S, T, A, L> Automaton<FlatRankingState<S, T>, ParityAcceptance> of(LimitDeterministicAutomaton<S, T, BuchiAcceptance, A> ldba, LanguageLattice<T, A, L> lattice, Predicate<? super S> isAcceptingState, boolean resetRanking, boolean optimizeInitialState) {
        Preconditions.checkArgument((boolean)ldba.initialStates().equals(ldba.initialComponent().initialStates()));
        Builder<? super S, T, A, L> builder = new Builder<S, T, A, L>(ldba, lattice, isAcceptingState, resetRanking);
        Automaton<FlatRankingState<S, T>, ParityAcceptance> automaton = AutomatonFactory.create(builder.ldba.acceptingComponent().factory(), builder.initialState, builder.acceptance, builder::getSuccessor);
        return optimizeInitialState ? AbstractBuilder.optimizeInitialState(automaton) : automaton;
    }

    static final class Builder<S, T, A, L>
    extends AbstractBuilder<S, T, A, L, BuchiAcceptance> {
        private static final Logger logger = Logger.getLogger(Builder.class.getName());
        private final boolean resetRanking;
        ParityAcceptance acceptance;
        final FlatRankingState<S, T> initialState;

        Builder(LimitDeterministicAutomaton<S, T, BuchiAcceptance, A> ldba, LanguageLattice<T, A, L> lattice, Predicate<? super S> isAcceptingState, boolean resetRanking) {
            super(ldba, lattice, isAcceptingState, resetRanking);
            logger.log(Level.FINER, "Safety Components: {0}", this.safetyComponents);
            this.acceptance = new ParityAcceptance(2 * Math.max(1, ldba.acceptingComponent().size() + 1), ParityAcceptance.Parity.MIN_ODD);
            this.resetRanking = resetRanking;
            S ldbaInitialState = ldba.initialComponent().onlyInitialState();
            this.initialState = this.buildEdge(ldbaInitialState, List.of(), -1, null).successor();
        }

        Edge<FlatRankingState<S, T>> buildEdge(S state, List<T> previousRanking, int previousSafetyProgress, @Nullable BitSet valuation) {
            if (this.isAcceptingState.test(state)) {
                return Edge.of(FlatRankingState.of(state), 1);
            }
            HashMap existingLanguages = new HashMap();
            ArrayList safetyTargets = new ArrayList();
            ArrayList livenessTargets = new ArrayList();
            ArrayList mixedTargets = new ArrayList();
            Language emptyLanguage = this.lattice.getBottom();
            ArrayList epsilonJumps = new ArrayList(this.ldba.epsilonJumps(state));
            epsilonJumps.sort(Comparator.comparingInt(x -> this.sortingOrder.indexOf(this.ldba.annotation(x))));
            for (Object jumpTarget : epsilonJumps) {
                existingLanguages.put(this.ldba.annotation(jumpTarget), emptyLanguage);
                if (this.lattice.acceptsSafetyLanguage(jumpTarget)) {
                    safetyTargets.add(jumpTarget);
                    continue;
                }
                if (this.lattice.acceptsLivenessLanguage(jumpTarget)) {
                    livenessTargets.add(jumpTarget);
                    continue;
                }
                mixedTargets.add(jumpTarget);
            }
            int edgeColor = 2 * previousRanking.size();
            ArrayList<Object> ranking = new ArrayList<Object>(previousRanking.size());
            int safetyProgress = -1;
            boolean extendRanking = true;
            Iterator<Object> iterator = previousRanking.listIterator();
            while (iterator.hasNext()) {
                assert (valuation != null) : "Valuation is only allowed to be null for empty rankings.";
                T previousState = iterator.next();
                Edge edge = this.ldba.acceptingComponent().edge(previousState, valuation);
                if (edge == null) {
                    edgeColor = Math.min(2 * iterator.previousIndex(), edgeColor);
                    continue;
                }
                Object rankingState = edge.successor();
                Object annotation = this.ldba.annotation(rankingState);
                Language existingLanguage = (Language)existingLanguages.get(annotation);
                if (existingLanguage == null || existingLanguage.greaterOrEqual(this.lattice.getLanguage(rankingState))) {
                    edgeColor = Math.min(2 * iterator.previousIndex(), edgeColor);
                    continue;
                }
                existingLanguages.replace(annotation, existingLanguage.join(this.lattice.getLanguage(rankingState)));
                ranking.add(rankingState);
                if (this.lattice.acceptsSafetyLanguage(rankingState) && !iterator.hasNext()) {
                    int safetyIndex = this.safetyComponents.indexOf(annotation);
                    edgeColor = Math.min(2 * iterator.previousIndex() + 1, edgeColor);
                    logger.log(Level.FINER, "Found safety language {0} with safety index {1}.", new Object[]{rankingState, safetyIndex});
                    if (this.resetRanking) {
                        existingLanguages.replace(annotation, this.lattice.getTop());
                    }
                    if (previousSafetyProgress != safetyIndex) continue;
                    safetyProgress = previousSafetyProgress;
                    extendRanking = false;
                    break;
                }
                if (!edge.inSet(0)) continue;
                edgeColor = Math.min(2 * iterator.previousIndex() + 1, edgeColor);
                if (!this.resetRanking) continue;
                existingLanguages.replace(annotation, this.lattice.getTop());
            }
            logger.log(Level.FINER, "Ranking before extension: {0}.", ranking);
            if (extendRanking) {
                for (Object accState : livenessTargets) {
                    if (!this.insertableToRanking(accState, existingLanguages)) continue;
                    ranking.add(accState);
                }
                for (Object accState : mixedTargets) {
                    if (!this.insertableToRanking(accState, existingLanguages)) continue;
                    ranking.add(accState);
                }
                Object safety = this.findNextSafety(safetyTargets, previousSafetyProgress + 1);
                if (safety == null) {
                    safety = this.findNextSafety(safetyTargets, 0);
                }
                if (safety != null) {
                    safetyProgress = this.safetyComponents.indexOf(this.ldba.annotation(safety));
                    if (this.insertableToRanking(safety, existingLanguages)) {
                        ranking.add(safety);
                    }
                }
            }
            logger.log(Level.FINER, "Ranking after extension: {0}.", ranking);
            return Edge.of(FlatRankingState.of(state, ranking, safetyProgress), edgeColor);
        }

        @Nullable
        Edge<FlatRankingState<S, T>> getSuccessor(FlatRankingState<S, T> state, BitSet valuation) {
            Edge<Object> edge = this.ldba.initialComponent().edge(state.state(), valuation);
            if (edge == null) {
                return null;
            }
            Object successor = edge.successor();
            if (this.sccSwitchOccurred(state.state(), successor)) {
                return Edge.of(this.buildEdge(successor, List.of(), -1, valuation).successor());
            }
            edge = this.buildEdge(successor, state.ranking(), state.safetyProgress(), valuation);
            assert (edge.largestAcceptanceSet() < this.acceptance.acceptanceSets());
            return edge;
        }
    }
}

