/*
 * Decompiled with CFR 0.152.
 */
package owl.translations.ltl2ldba;

import java.util.Collection;
import java.util.Set;
import owl.translations.ltl2ldba.Jump;
import owl.translations.ltl2ldba.RecurringObligation;

final class AnalysisResult<U extends RecurringObligation> {
    final Set<Jump<U>> jumps;
    final TYPE type;

    private AnalysisResult(TYPE type, Set<Jump<U>> jumps) {
        this.type = type;
        this.jumps = jumps;
    }

    static <U extends RecurringObligation> AnalysisResult<U> buildMay(Collection<Jump<U>> jumps) {
        return new AnalysisResult<U>(TYPE.MAY, Set.copyOf(jumps));
    }

    static <U extends RecurringObligation> AnalysisResult<U> buildMust(Jump<U> jump) {
        return new AnalysisResult<U>(TYPE.MUST, Set.of(jump));
    }

    static enum TYPE {
        MAY,
        MUST;

    }
}

