/*
 * Decompiled with CFR 0.152.
 */
package owl.translations.ltl2ldba;

import de.tum.in.naturals.bitset.BitSets;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import owl.collections.LabelledTree;
import owl.collections.ValuationSet;
import owl.factories.Factories;
import owl.ltl.Conjunction;
import owl.ltl.EquivalenceClass;
import owl.ltl.Formula;
import owl.ltl.rewriter.NormalForms;
import owl.translations.ltl2ldba.LTL2LDBAFunction;

public class EquivalenceClassStateFactory {
    private final boolean eagerUnfold;
    private final Factories factories;
    private final boolean removeRedundantObligations;

    EquivalenceClassStateFactory(Factories factories, Set<LTL2LDBAFunction.Configuration> configuration) {
        this(factories, configuration.contains((Object)LTL2LDBAFunction.Configuration.EAGER_UNFOLD), configuration.contains((Object)LTL2LDBAFunction.Configuration.OPTIMISED_STATE_STRUCTURE));
    }

    public EquivalenceClassStateFactory(Factories factories, boolean eagerUnfold, boolean removeRedundantObligations) {
        this.factories = factories;
        this.eagerUnfold = eagerUnfold;
        this.removeRedundantObligations = removeRedundantObligations;
    }

    public EquivalenceClass getInitial(Formula ... formulas) {
        return this.getInitial(Arrays.asList(formulas));
    }

    private EquivalenceClass getInitial(Collection<Formula> formulas) {
        return this.getInitial(this.factories.eqFactory.of(Conjunction.of(formulas)), new EquivalenceClass[0]);
    }

    public EquivalenceClass getInitial(EquivalenceClass clazz, EquivalenceClass ... environmentArray) {
        EquivalenceClass initial = this.eagerUnfold ? clazz.unfold() : clazz;
        return this.removeRedundantObligations(initial, environmentArray);
    }

    public EquivalenceClass getNondeterministicSuccessor(EquivalenceClass clazz, BitSet valuation) {
        return this.eagerUnfold ? clazz.temporalStep(valuation) : clazz.unfoldTemporalStep(valuation);
    }

    public BitSet getSensitiveAlphabet(EquivalenceClass clazz) {
        if (this.eagerUnfold) {
            return clazz.atomicPropositions();
        }
        return clazz.unfold().atomicPropositions();
    }

    public EquivalenceClass getSuccessor(EquivalenceClass clazz, BitSet valuation, EquivalenceClass ... environmentArray) {
        EquivalenceClass successor = this.eagerUnfold ? clazz.temporalStepUnfold(valuation) : clazz.unfoldTemporalStep(valuation);
        return this.removeRedundantObligations(successor, environmentArray);
    }

    public Map<EquivalenceClass, ValuationSet> getSuccessors(EquivalenceClass clazz) {
        LabelledTree<Integer, EquivalenceClass> tree = this.eagerUnfold ? clazz.temporalStepTree() : clazz.unfold().temporalStepTree();
        return this.getSuccessorsRecursive(tree, new HashMap<LabelledTree<Integer, EquivalenceClass>, Map<EquivalenceClass, ValuationSet>>());
    }

    private Map<EquivalenceClass, ValuationSet> getSuccessorsRecursive(LabelledTree<Integer, EquivalenceClass> tree, Map<LabelledTree<Integer, EquivalenceClass>, Map<EquivalenceClass, ValuationSet>> cache) {
        Map<EquivalenceClass, ValuationSet> map = cache.get(tree);
        if (map != null) {
            return map;
        }
        if (tree instanceof LabelledTree.Leaf) {
            EquivalenceClass label = (EquivalenceClass)((LabelledTree.Leaf)tree).getLabel();
            EquivalenceClass clazz2 = this.eagerUnfold ? label.unfold() : label;
            map = clazz2.isFalse() ? Map.of() : Map.of(clazz2, this.factories.vsFactory.universe());
        } else {
            BitSet literal = BitSets.of((int)((Integer)((LabelledTree.Node)tree).getLabel()));
            ValuationSet posMask = this.factories.vsFactory.of(literal, literal);
            ValuationSet negMask = posMask.complement();
            List children = ((LabelledTree.Node)tree).getChildren();
            HashMap<EquivalenceClass, ValuationSet> finalMap = new HashMap<EquivalenceClass, ValuationSet>();
            this.getSuccessorsRecursive(children.get(0), cache).forEach((clazz, set) -> finalMap.merge((EquivalenceClass)clazz, set.intersection(posMask), ValuationSet::union));
            this.getSuccessorsRecursive(children.get(1), cache).forEach((clazz, set) -> finalMap.merge((EquivalenceClass)clazz, set.intersection(negMask), ValuationSet::union));
            map = finalMap;
        }
        cache.put(tree, map);
        return map;
    }

    @Nullable
    public EquivalenceClass[] getSuccessors(EquivalenceClass[] clazz, BitSet valuation, @Nullable EquivalenceClass environment) {
        EquivalenceClass[] successors = new EquivalenceClass[clazz.length];
        for (int i = clazz.length - 1; i >= 0; --i) {
            successors[i] = this.getSuccessor(clazz[i], valuation, environment);
            if (!successors[i].isFalse()) continue;
            return null;
        }
        return successors;
    }

    private EquivalenceClass removeRedundantObligations(EquivalenceClass state, EquivalenceClass ... environmentArray) {
        EquivalenceClass environment;
        if (this.removeRedundantObligations && environmentArray.length > 0 && (environment = this.factories.eqFactory.conjunction(environmentArray)).implies(state)) {
            return this.factories.eqFactory.getTrue();
        }
        return state;
    }

    public List<EquivalenceClass> splitEquivalenceClass(EquivalenceClass clazz) {
        assert (clazz.representative() != null);
        List<EquivalenceClass> successors = NormalForms.toDnf(clazz.representative()).stream().map(this::getInitial).collect(Collectors.toList());
        if (this.removeRedundantObligations) {
            successors.removeIf(x -> successors.stream().anyMatch(y -> x != y && x.implies((EquivalenceClass)y)));
        }
        return successors;
    }
}

