/*
 * Decompiled with CFR 0.152.
 */
package owl.translations.ltl2ldba;

import java.util.HashSet;
import java.util.Set;
import owl.ltl.BooleanConstant;
import owl.ltl.EquivalenceClass;
import owl.ltl.Formula;
import owl.ltl.SyntacticFragment;
import owl.ltl.visitors.Collector;

public final class SafetyDetector {
    private SafetyDetector() {
    }

    public static boolean hasSafetyCore(EquivalenceClass state, boolean substitutionAnalysis) {
        Set<Formula> modalOperators = state.modalOperators();
        if (modalOperators.stream().allMatch(SyntacticFragment.SAFETY::contains)) {
            return true;
        }
        if (substitutionAnalysis) {
            HashSet coreComplement = new HashSet();
            modalOperators.forEach(x -> {
                if (!SyntacticFragment.SAFETY.contains((Formula)x)) {
                    coreComplement.add(x);
                }
            });
            EquivalenceClass core = state.substitute(x -> coreComplement.stream().anyMatch(y -> y.anyMatch(x::equals)) ? BooleanConstant.FALSE : x);
            return !core.isFalse() && !core.atomicPropositions().intersects(Collector.collectAtoms(coreComplement));
        }
        return false;
    }
}

