/*
 * Decompiled with CFR 0.152.
 */
package owl.translations.ltl2ldba.breakpointfree;

import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Nullable;
import owl.collections.Collections3;
import owl.factories.EquivalenceClassFactory;
import owl.ltl.BooleanConstant;
import owl.ltl.Conjunction;
import owl.ltl.EquivalenceClass;
import owl.ltl.FOperator;
import owl.ltl.Formula;
import owl.ltl.GOperator;
import owl.ltl.UnaryModalOperator;
import owl.ltl.XOperator;
import owl.ltl.rewriter.SimplifierFactory;
import owl.translations.ltl2ldba.RecurringObligation;
import owl.translations.ltl2ldba.breakpointfree.FGObligationsJumpManager;

public final class FGObligations
implements RecurringObligation {
    final Set<FOperator> fOperators;
    final Set<GOperator> gOperators;
    final List<EquivalenceClass> liveness;
    final Set<UnaryModalOperator> rewrittenOperators;
    final EquivalenceClass safety;

    private FGObligations(Set<FOperator> fOperators, Set<GOperator> gOperators, EquivalenceClass safety, List<EquivalenceClass> liveness, Set<UnaryModalOperator> rewrittenOperators) {
        this.safety = safety;
        this.liveness = List.copyOf(liveness);
        this.gOperators = Set.copyOf(gOperators);
        this.fOperators = Set.copyOf(fOperators);
        this.rewrittenOperators = Set.copyOf(rewrittenOperators);
    }

    @Nullable
    static FGObligations build(Set<FOperator> fOperators1, Set<GOperator> gOperators1, EquivalenceClassFactory factory) {
        Set<FOperator> fOperators = Set.copyOf(fOperators1);
        Set<GOperator> gOperators = Set.copyOf(gOperators1);
        HashSet<UnaryModalOperator> builder = new HashSet<UnaryModalOperator>();
        EquivalenceClass safety = factory.getTrue();
        for (GOperator gOperator : gOperators) {
            Formula formula = FGObligationsJumpManager.replaceFOperators(fOperators, gOperators, gOperator);
            EquivalenceClass safety2 = factory.of(formula);
            if ((safety = safety.and(safety2)).unfold().isFalse()) {
                return null;
            }
            if ((formula = GOperator.of(formula)) instanceof GOperator) {
                builder.add((GOperator)formula);
                continue;
            }
            builder.add(new GOperator(formula));
        }
        ArrayList<EquivalenceClass> livenessList = new ArrayList<EquivalenceClass>(fOperators.size());
        for (FOperator fOperator : fOperators) {
            Formula formula = FGObligationsJumpManager.replaceGOperators(gOperators, fOperators, fOperator);
            formula = SimplifierFactory.apply(formula, SimplifierFactory.Mode.SYNTACTIC_FIXPOINT);
            formula = SimplifierFactory.apply(formula, SimplifierFactory.Mode.PULL_UP_X);
            while (formula instanceof XOperator) {
                formula = ((UnaryModalOperator)formula).operand;
            }
            if (formula == BooleanConstant.FALSE) {
                return null;
            }
            if (formula == BooleanConstant.TRUE) {
                Logger.getGlobal().log(Level.FINER, "Found true obligation.");
                continue;
            }
            if ((formula = FOperator.of(formula)) instanceof FOperator) {
                builder.add((FOperator)formula);
            } else {
                builder.add(new FOperator(formula));
            }
            EquivalenceClass liveness = factory.of(formula);
            livenessList.add(liveness);
        }
        return new FGObligations(fOperators, gOperators, safety, livenessList, builder);
    }

    @Override
    public boolean containsLanguageOf(RecurringObligation other) {
        Preconditions.checkArgument((boolean)(other instanceof FGObligations));
        return ((FGObligations)other).rewrittenOperators.containsAll(this.rewrittenOperators);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FGObligations that = (FGObligations)o;
        return Objects.equals(this.fOperators, that.fOperators) && Objects.equals(this.gOperators, that.gOperators) && Objects.equals(this.safety, that.safety) && Objects.equals(this.liveness, that.liveness);
    }

    @Override
    public EquivalenceClass getLanguage() {
        return this.safety.factory().of(Conjunction.of(Collections3.transformUnique(this.rewrittenOperators, GOperator::of)));
    }

    EquivalenceClass getObligation() {
        EquivalenceClass obligation = this.safety;
        for (EquivalenceClass clazz : this.liveness) {
            obligation = obligation.and(clazz);
        }
        return obligation;
    }

    public int hashCode() {
        return Objects.hash(this.fOperators, this.gOperators, this.safety, this.liveness);
    }

    boolean isPureLiveness() {
        return this.safety.isTrue();
    }

    boolean isPureSafety() {
        return this.liveness.isEmpty();
    }

    public String toString() {
        return "<" + this.fOperators + ", " + this.gOperators + ">";
    }
}

