/*
 * Decompiled with CFR 0.152.
 */
package owl.translations.rabinizer;

import com.google.common.base.MoreObjects;
import com.google.common.primitives.Booleans;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.util.ArrayList;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;
import owl.translations.rabinizer.RabinizerConfiguration;

@ParametersAreNonnullByDefault
@Generated(from="RabinizerConfiguration", generator="Immutables")
@CheckReturnValue
@Immutable
public final class ImmutableRabinizerConfiguration
extends RabinizerConfiguration {
    private final boolean completeAutomaton;
    private final boolean computeAcceptance;
    private final boolean eager;
    private final boolean supportBasedRelevantFormulaAnalysis;
    private final boolean suspendableFormulaDetection;
    private final boolean removeFormulaRepresentative;
    private static final byte STAGE_INITIALIZING = -1;
    private static final byte STAGE_UNINITIALIZED = 0;
    private static final byte STAGE_INITIALIZED = 1;
    private volatile transient InitShim initShim = new InitShim();

    private ImmutableRabinizerConfiguration(Builder builder) {
        if (builder.completeAutomatonIsSet()) {
            this.initShim.completeAutomaton(builder.completeAutomaton);
        }
        if (builder.computeAcceptanceIsSet()) {
            this.initShim.computeAcceptance(builder.computeAcceptance);
        }
        if (builder.eagerIsSet()) {
            this.initShim.eager(builder.eager);
        }
        if (builder.supportBasedRelevantFormulaAnalysisIsSet()) {
            this.initShim.supportBasedRelevantFormulaAnalysis(builder.supportBasedRelevantFormulaAnalysis);
        }
        if (builder.suspendableFormulaDetectionIsSet()) {
            this.initShim.suspendableFormulaDetection(builder.suspendableFormulaDetection);
        }
        if (builder.removeFormulaRepresentativeIsSet()) {
            this.initShim.removeFormulaRepresentative(builder.removeFormulaRepresentative);
        }
        this.completeAutomaton = this.initShim.completeAutomaton();
        this.computeAcceptance = this.initShim.computeAcceptance();
        this.eager = this.initShim.eager();
        this.supportBasedRelevantFormulaAnalysis = this.initShim.supportBasedRelevantFormulaAnalysis();
        this.suspendableFormulaDetection = this.initShim.suspendableFormulaDetection();
        this.removeFormulaRepresentative = this.initShim.removeFormulaRepresentative();
        this.initShim = null;
    }

    private ImmutableRabinizerConfiguration(boolean completeAutomaton, boolean computeAcceptance, boolean eager, boolean supportBasedRelevantFormulaAnalysis, boolean suspendableFormulaDetection, boolean removeFormulaRepresentative) {
        this.completeAutomaton = completeAutomaton;
        this.computeAcceptance = computeAcceptance;
        this.eager = eager;
        this.supportBasedRelevantFormulaAnalysis = supportBasedRelevantFormulaAnalysis;
        this.suspendableFormulaDetection = suspendableFormulaDetection;
        this.removeFormulaRepresentative = removeFormulaRepresentative;
        this.initShim = null;
    }

    @Override
    public boolean completeAutomaton() {
        InitShim shim = this.initShim;
        return shim != null ? shim.completeAutomaton() : this.completeAutomaton;
    }

    @Override
    public boolean computeAcceptance() {
        InitShim shim = this.initShim;
        return shim != null ? shim.computeAcceptance() : this.computeAcceptance;
    }

    @Override
    public boolean eager() {
        InitShim shim = this.initShim;
        return shim != null ? shim.eager() : this.eager;
    }

    @Override
    public boolean supportBasedRelevantFormulaAnalysis() {
        InitShim shim = this.initShim;
        return shim != null ? shim.supportBasedRelevantFormulaAnalysis() : this.supportBasedRelevantFormulaAnalysis;
    }

    @Override
    public boolean suspendableFormulaDetection() {
        InitShim shim = this.initShim;
        return shim != null ? shim.suspendableFormulaDetection() : this.suspendableFormulaDetection;
    }

    @Override
    public boolean removeFormulaRepresentative() {
        InitShim shim = this.initShim;
        return shim != null ? shim.removeFormulaRepresentative() : this.removeFormulaRepresentative;
    }

    public final ImmutableRabinizerConfiguration withCompleteAutomaton(boolean value) {
        if (this.completeAutomaton == value) {
            return this;
        }
        return new ImmutableRabinizerConfiguration(value, this.computeAcceptance, this.eager, this.supportBasedRelevantFormulaAnalysis, this.suspendableFormulaDetection, this.removeFormulaRepresentative);
    }

    public final ImmutableRabinizerConfiguration withComputeAcceptance(boolean value) {
        if (this.computeAcceptance == value) {
            return this;
        }
        return new ImmutableRabinizerConfiguration(this.completeAutomaton, value, this.eager, this.supportBasedRelevantFormulaAnalysis, this.suspendableFormulaDetection, this.removeFormulaRepresentative);
    }

    public final ImmutableRabinizerConfiguration withEager(boolean value) {
        if (this.eager == value) {
            return this;
        }
        return new ImmutableRabinizerConfiguration(this.completeAutomaton, this.computeAcceptance, value, this.supportBasedRelevantFormulaAnalysis, this.suspendableFormulaDetection, this.removeFormulaRepresentative);
    }

    public final ImmutableRabinizerConfiguration withSupportBasedRelevantFormulaAnalysis(boolean value) {
        if (this.supportBasedRelevantFormulaAnalysis == value) {
            return this;
        }
        return new ImmutableRabinizerConfiguration(this.completeAutomaton, this.computeAcceptance, this.eager, value, this.suspendableFormulaDetection, this.removeFormulaRepresentative);
    }

    public final ImmutableRabinizerConfiguration withSuspendableFormulaDetection(boolean value) {
        if (this.suspendableFormulaDetection == value) {
            return this;
        }
        return new ImmutableRabinizerConfiguration(this.completeAutomaton, this.computeAcceptance, this.eager, this.supportBasedRelevantFormulaAnalysis, value, this.removeFormulaRepresentative);
    }

    public final ImmutableRabinizerConfiguration withRemoveFormulaRepresentative(boolean value) {
        if (this.removeFormulaRepresentative == value) {
            return this;
        }
        return new ImmutableRabinizerConfiguration(this.completeAutomaton, this.computeAcceptance, this.eager, this.supportBasedRelevantFormulaAnalysis, this.suspendableFormulaDetection, value);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableRabinizerConfiguration && this.equalTo((ImmutableRabinizerConfiguration)another);
    }

    private boolean equalTo(ImmutableRabinizerConfiguration another) {
        return this.completeAutomaton == another.completeAutomaton && this.computeAcceptance == another.computeAcceptance && this.eager == another.eager && this.supportBasedRelevantFormulaAnalysis == another.supportBasedRelevantFormulaAnalysis && this.suspendableFormulaDetection == another.suspendableFormulaDetection && this.removeFormulaRepresentative == another.removeFormulaRepresentative;
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + Booleans.hashCode((boolean)this.completeAutomaton);
        h += (h << 5) + Booleans.hashCode((boolean)this.computeAcceptance);
        h += (h << 5) + Booleans.hashCode((boolean)this.eager);
        h += (h << 5) + Booleans.hashCode((boolean)this.supportBasedRelevantFormulaAnalysis);
        h += (h << 5) + Booleans.hashCode((boolean)this.suspendableFormulaDetection);
        h += (h << 5) + Booleans.hashCode((boolean)this.removeFormulaRepresentative);
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"RabinizerConfiguration").omitNullValues().add("completeAutomaton", this.completeAutomaton).add("computeAcceptance", this.computeAcceptance).add("eager", this.eager).add("supportBasedRelevantFormulaAnalysis", this.supportBasedRelevantFormulaAnalysis).add("suspendableFormulaDetection", this.suspendableFormulaDetection).add("removeFormulaRepresentative", this.removeFormulaRepresentative).toString();
    }

    public static ImmutableRabinizerConfiguration copyOf(RabinizerConfiguration instance) {
        if (instance instanceof ImmutableRabinizerConfiguration) {
            return (ImmutableRabinizerConfiguration)instance;
        }
        return ImmutableRabinizerConfiguration.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @NotThreadSafe
    public static final class Builder {
        private static final long OPT_BIT_COMPLETE_AUTOMATON = 1L;
        private static final long OPT_BIT_COMPUTE_ACCEPTANCE = 2L;
        private static final long OPT_BIT_EAGER = 4L;
        private static final long OPT_BIT_SUPPORT_BASED_RELEVANT_FORMULA_ANALYSIS = 8L;
        private static final long OPT_BIT_SUSPENDABLE_FORMULA_DETECTION = 16L;
        private static final long OPT_BIT_REMOVE_FORMULA_REPRESENTATIVE = 32L;
        private long optBits;
        private boolean completeAutomaton;
        private boolean computeAcceptance;
        private boolean eager;
        private boolean supportBasedRelevantFormulaAnalysis;
        private boolean suspendableFormulaDetection;
        private boolean removeFormulaRepresentative;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(RabinizerConfiguration instance) {
            Objects.requireNonNull(instance, "instance");
            this.completeAutomaton(instance.completeAutomaton());
            this.computeAcceptance(instance.computeAcceptance());
            this.eager(instance.eager());
            this.supportBasedRelevantFormulaAnalysis(instance.supportBasedRelevantFormulaAnalysis());
            this.suspendableFormulaDetection(instance.suspendableFormulaDetection());
            this.removeFormulaRepresentative(instance.removeFormulaRepresentative());
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder completeAutomaton(boolean completeAutomaton) {
            this.completeAutomaton = completeAutomaton;
            this.optBits |= 1L;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder computeAcceptance(boolean computeAcceptance) {
            this.computeAcceptance = computeAcceptance;
            this.optBits |= 2L;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder eager(boolean eager) {
            this.eager = eager;
            this.optBits |= 4L;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder supportBasedRelevantFormulaAnalysis(boolean supportBasedRelevantFormulaAnalysis) {
            this.supportBasedRelevantFormulaAnalysis = supportBasedRelevantFormulaAnalysis;
            this.optBits |= 8L;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder suspendableFormulaDetection(boolean suspendableFormulaDetection) {
            this.suspendableFormulaDetection = suspendableFormulaDetection;
            this.optBits |= 0x10L;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder removeFormulaRepresentative(boolean removeFormulaRepresentative) {
            this.removeFormulaRepresentative = removeFormulaRepresentative;
            this.optBits |= 0x20L;
            return this;
        }

        public ImmutableRabinizerConfiguration build() {
            return new ImmutableRabinizerConfiguration(this);
        }

        private boolean completeAutomatonIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private boolean computeAcceptanceIsSet() {
            return (this.optBits & 2L) != 0L;
        }

        private boolean eagerIsSet() {
            return (this.optBits & 4L) != 0L;
        }

        private boolean supportBasedRelevantFormulaAnalysisIsSet() {
            return (this.optBits & 8L) != 0L;
        }

        private boolean suspendableFormulaDetectionIsSet() {
            return (this.optBits & 0x10L) != 0L;
        }

        private boolean removeFormulaRepresentativeIsSet() {
            return (this.optBits & 0x20L) != 0L;
        }
    }

    private final class InitShim {
        private byte completeAutomatonBuildStage = 0;
        private boolean completeAutomaton;
        private byte computeAcceptanceBuildStage = 0;
        private boolean computeAcceptance;
        private byte eagerBuildStage = 0;
        private boolean eager;
        private byte supportBasedRelevantFormulaAnalysisBuildStage = 0;
        private boolean supportBasedRelevantFormulaAnalysis;
        private byte suspendableFormulaDetectionBuildStage = 0;
        private boolean suspendableFormulaDetection;
        private byte removeFormulaRepresentativeBuildStage = 0;
        private boolean removeFormulaRepresentative;

        private InitShim() {
        }

        boolean completeAutomaton() {
            if (this.completeAutomatonBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.completeAutomatonBuildStage == 0) {
                this.completeAutomatonBuildStage = (byte)-1;
                this.completeAutomaton = ImmutableRabinizerConfiguration.super.completeAutomaton();
                this.completeAutomatonBuildStage = 1;
            }
            return this.completeAutomaton;
        }

        void completeAutomaton(boolean completeAutomaton) {
            this.completeAutomaton = completeAutomaton;
            this.completeAutomatonBuildStage = 1;
        }

        boolean computeAcceptance() {
            if (this.computeAcceptanceBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.computeAcceptanceBuildStage == 0) {
                this.computeAcceptanceBuildStage = (byte)-1;
                this.computeAcceptance = ImmutableRabinizerConfiguration.super.computeAcceptance();
                this.computeAcceptanceBuildStage = 1;
            }
            return this.computeAcceptance;
        }

        void computeAcceptance(boolean computeAcceptance) {
            this.computeAcceptance = computeAcceptance;
            this.computeAcceptanceBuildStage = 1;
        }

        boolean eager() {
            if (this.eagerBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.eagerBuildStage == 0) {
                this.eagerBuildStage = (byte)-1;
                this.eager = ImmutableRabinizerConfiguration.super.eager();
                this.eagerBuildStage = 1;
            }
            return this.eager;
        }

        void eager(boolean eager) {
            this.eager = eager;
            this.eagerBuildStage = 1;
        }

        boolean supportBasedRelevantFormulaAnalysis() {
            if (this.supportBasedRelevantFormulaAnalysisBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.supportBasedRelevantFormulaAnalysisBuildStage == 0) {
                this.supportBasedRelevantFormulaAnalysisBuildStage = (byte)-1;
                this.supportBasedRelevantFormulaAnalysis = ImmutableRabinizerConfiguration.super.supportBasedRelevantFormulaAnalysis();
                this.supportBasedRelevantFormulaAnalysisBuildStage = 1;
            }
            return this.supportBasedRelevantFormulaAnalysis;
        }

        void supportBasedRelevantFormulaAnalysis(boolean supportBasedRelevantFormulaAnalysis) {
            this.supportBasedRelevantFormulaAnalysis = supportBasedRelevantFormulaAnalysis;
            this.supportBasedRelevantFormulaAnalysisBuildStage = 1;
        }

        boolean suspendableFormulaDetection() {
            if (this.suspendableFormulaDetectionBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.suspendableFormulaDetectionBuildStage == 0) {
                this.suspendableFormulaDetectionBuildStage = (byte)-1;
                this.suspendableFormulaDetection = ImmutableRabinizerConfiguration.super.suspendableFormulaDetection();
                this.suspendableFormulaDetectionBuildStage = 1;
            }
            return this.suspendableFormulaDetection;
        }

        void suspendableFormulaDetection(boolean suspendableFormulaDetection) {
            this.suspendableFormulaDetection = suspendableFormulaDetection;
            this.suspendableFormulaDetectionBuildStage = 1;
        }

        boolean removeFormulaRepresentative() {
            if (this.removeFormulaRepresentativeBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.removeFormulaRepresentativeBuildStage == 0) {
                this.removeFormulaRepresentativeBuildStage = (byte)-1;
                this.removeFormulaRepresentative = ImmutableRabinizerConfiguration.super.removeFormulaRepresentative();
                this.removeFormulaRepresentativeBuildStage = 1;
            }
            return this.removeFormulaRepresentative;
        }

        void removeFormulaRepresentative(boolean removeFormulaRepresentative) {
            this.removeFormulaRepresentative = removeFormulaRepresentative;
            this.removeFormulaRepresentativeBuildStage = 1;
        }

        private String formatInitCycleMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (this.completeAutomatonBuildStage == -1) {
                attributes.add("completeAutomaton");
            }
            if (this.computeAcceptanceBuildStage == -1) {
                attributes.add("computeAcceptance");
            }
            if (this.eagerBuildStage == -1) {
                attributes.add("eager");
            }
            if (this.supportBasedRelevantFormulaAnalysisBuildStage == -1) {
                attributes.add("supportBasedRelevantFormulaAnalysis");
            }
            if (this.suspendableFormulaDetectionBuildStage == -1) {
                attributes.add("suspendableFormulaDetection");
            }
            if (this.removeFormulaRepresentativeBuildStage == -1) {
                attributes.add("removeFormulaRepresentative");
            }
            return "Cannot build RabinizerConfiguration, attribute initializers form cycle " + attributes;
        }
    }
}

