/*
 * Decompiled with CFR 0.152.
 */
package de.tum.in.naturals.set;

import it.unimi.dsi.fastutil.ints.AbstractIntSet;
import it.unimi.dsi.fastutil.ints.IntArrays;
import it.unimi.dsi.fastutil.ints.IntCollection;
import it.unimi.dsi.fastutil.ints.IntIterator;
import java.util.Arrays;
import java.util.Collection;
import java.util.NoSuchElementException;

public class IntArraySortedSet
extends AbstractIntSet {
    private int[] array;
    private int size;

    public IntArraySortedSet() {
        this.array = IntArrays.EMPTY_ARRAY;
    }

    public IntArraySortedSet(int capacity) {
        this.array = new int[capacity];
    }

    public IntArraySortedSet(IntCollection c) {
        this(c.size());
        this.addAll(c);
    }

    public IntArraySortedSet(Collection<? extends Integer> c) {
        this(c.size());
        this.addAll(c);
    }

    public IntArraySortedSet(int[] array, int size) {
        if (size > array.length) {
            throw new IllegalArgumentException(String.format("Size %d larger than array %d", size, array.length));
        }
        assert (IntArraySortedSet.isSortedUnique(array, size));
        this.array = array;
        this.size = size;
    }

    public IntArraySortedSet(int[] array) {
        assert (IntArraySortedSet.isSortedUnique(array, array.length));
        this.array = array;
        this.size = array.length;
    }

    private static boolean isSortedUnique(int[] array, int size) {
        assert (size <= array.length);
        if (array.length <= 1) {
            return true;
        }
        int val = array[0];
        for (int i = 1; i < size; ++i) {
            int next = array[i];
            if (next <= val) {
                return false;
            }
            val = next;
        }
        return true;
    }

    public boolean add(int k) {
        if (this.array.length == 0) {
            this.array = new int[]{k, 0};
            this.size = 1;
            return true;
        }
        int index = this.keyIndex(k);
        if (index >= 0) {
            return false;
        }
        int insertionPoint = -(index + 1);
        int tailLength = this.size - insertionPoint;
        if (this.size == this.array.length) {
            int newSize = this.size * 2;
            if (insertionPoint == this.size) {
                this.array = Arrays.copyOf(this.array, newSize);
                this.array[insertionPoint] = k;
            } else {
                int[] newArray = new int[newSize];
                System.arraycopy(this.array, 0, newArray, 0, insertionPoint);
                System.arraycopy(this.array, insertionPoint, newArray, insertionPoint + 1, tailLength);
                this.array = newArray;
                newArray[insertionPoint] = k;
            }
        } else if (insertionPoint == this.size) {
            this.array[this.size] = k;
        } else {
            System.arraycopy(this.array, insertionPoint, this.array, insertionPoint + 1, tailLength);
            this.array[insertionPoint] = k;
        }
        ++this.size;
        return true;
    }

    public void clear() {
        this.size = 0;
    }

    public IntArraySortedSet clone() {
        IntArraySortedSet clone;
        try {
            clone = (IntArraySortedSet)((Object)super.clone());
        }
        catch (CloneNotSupportedException ignored) {
            throw new InternalError(ignored);
        }
        clone.array = (int[])this.array.clone();
        return clone;
    }

    public boolean contains(int k) {
        return this.keyIndex(k) >= 0;
    }

    public boolean isEmpty() {
        return this.size == 0;
    }

    public IntIterator iterator() {
        return new Iterator(this);
    }

    private int keyIndex(int key) {
        return Arrays.binarySearch(this.array, 0, this.size, key);
    }

    public boolean remove(int k) {
        int index = this.keyIndex(k);
        if (index < 0) {
            return false;
        }
        this.removeIndex(index);
        return true;
    }

    private void removeIndex(int index) {
        int nextIndex = index + 1;
        if (nextIndex < this.size) {
            int tail = this.size - nextIndex;
            System.arraycopy(this.array, nextIndex, this.array, index, tail);
        }
        --this.size;
    }

    public int size() {
        return this.size;
    }

    public void trim() {
        if (this.array.length == this.size) {
            return;
        }
        this.array = Arrays.copyOf(this.array, this.size);
    }

    private static class Iterator
    implements IntIterator {
        private final IntArraySortedSet set;
        private int next = 0;

        Iterator(IntArraySortedSet set) {
            this.set = set;
        }

        public boolean hasNext() {
            return this.next < this.set.size;
        }

        public int nextInt() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            int result = this.set.array[this.next];
            ++this.next;
            return result;
        }

        public void remove() {
            --this.next;
            this.set.removeIndex(this.next);
        }
    }
}

