/*
 * Decompiled with CFR 0.152.
 */
package owl.factories;

import java.util.BitSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.IntUnaryOperator;
import javax.annotation.Nullable;
import jhoafparser.ast.AtomLabel;
import jhoafparser.ast.BooleanExpression;
import owl.collections.ValuationSet;
import owl.collections.ValuationTree;

public interface ValuationSetFactory {
    public List<String> alphabet();

    default public int alphabetSize() {
        return this.alphabet().size();
    }

    public ValuationSet of(int var1);

    public ValuationSet of(BitSet var1);

    public ValuationSet of(BitSet var1, BitSet var2);

    default public ValuationSet of(BooleanExpression<AtomLabel> expression, @Nullable IntUnaryOperator mapping) {
        if (expression.isFALSE()) {
            return this.empty();
        }
        if (expression.isTRUE()) {
            return this.universe();
        }
        if (expression.isAtom()) {
            int apIndex = ((AtomLabel)expression.getAtom()).getAPIndex();
            return this.of(mapping == null ? apIndex : mapping.applyAsInt(apIndex));
        }
        if (expression.isNOT()) {
            return this.of((BooleanExpression<AtomLabel>)expression.getLeft(), mapping).complement();
        }
        if (expression.isAND()) {
            ValuationSet left = this.of((BooleanExpression<AtomLabel>)expression.getLeft(), mapping);
            ValuationSet right = this.of((BooleanExpression<AtomLabel>)expression.getRight(), mapping);
            return left.intersection(right);
        }
        if (expression.isOR()) {
            ValuationSet left = this.of((BooleanExpression<AtomLabel>)expression.getLeft(), mapping);
            ValuationSet right = this.of((BooleanExpression<AtomLabel>)expression.getRight(), mapping);
            return left.union(right);
        }
        throw new IllegalArgumentException("Unsupported Case: " + expression);
    }

    public ValuationSet empty();

    public ValuationSet universe();

    public ValuationSet complement(ValuationSet var1);

    default public void forEach(Consumer<BitSet> action) {
        this.universe().forEach(action);
    }

    public BitSet any(ValuationSet var1);

    public boolean contains(ValuationSet var1, BitSet var2);

    public boolean contains(ValuationSet var1, ValuationSet var2);

    public boolean intersects(ValuationSet var1, ValuationSet var2);

    public void forEach(ValuationSet var1, Consumer<? super BitSet> var2);

    public void forEach(ValuationSet var1, BitSet var2, Consumer<? super BitSet> var3);

    public ValuationSet intersection(ValuationSet var1, ValuationSet var2);

    default public ValuationSet intersection(Iterable<ValuationSet> sets) {
        return this.intersection(sets.iterator());
    }

    public ValuationSet intersection(Iterator<ValuationSet> var1);

    public ValuationSet union(ValuationSet var1, ValuationSet var2);

    default public ValuationSet union(Iterable<ValuationSet> sets) {
        return this.union(sets.iterator());
    }

    public ValuationSet union(Iterator<ValuationSet> var1);

    default public ValuationSet minus(ValuationSet set1, ValuationSet set2) {
        return set1.intersection(set2.complement());
    }

    public BooleanExpression<AtomLabel> toExpression(ValuationSet var1);

    public <S> ValuationTree<S> inverse(Map<S, ValuationSet> var1);
}

