/*
 * Decompiled with CFR 0.152.
 */
package owl.ltl;

import java.util.Arrays;
import java.util.BitSet;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nonnegative;
import owl.ltl.Formula;
import owl.ltl.visitors.BinaryVisitor;
import owl.ltl.visitors.IntVisitor;
import owl.ltl.visitors.Visitor;

public final class Literal
extends Formula.TemporalOperator {
    private static final int CACHE_SIZE = 128;
    private static final Literal[] cache = new Literal[128];
    private final int index;
    private final Literal negation;

    private Literal(Literal other) {
        super(Integer.hashCode(-other.index));
        this.index = -other.index;
        this.negation = other;
        assert (this.getAtom() == other.getAtom() && this.isNegated() ^ other.isNegated());
    }

    private Literal(@Nonnegative int index) {
        super(Integer.hashCode(index + 1));
        Objects.checkIndex(index, Integer.MAX_VALUE);
        this.index = index + 1;
        this.negation = new Literal(this);
        assert (this.getAtom() == this.negation.getAtom() && this.isNegated() ^ this.negation.isNegated());
    }

    public static Literal of(@Nonnegative int index) {
        return Literal.of(index, false);
    }

    public static Literal of(@Nonnegative int index, boolean negate) {
        if (index >= 128) {
            Literal literal = new Literal(index);
            return negate ? literal.negation : literal;
        }
        Literal literal = cache[index];
        return negate ? literal.negation : literal;
    }

    @Override
    public int accept(IntVisitor v) {
        return v.visit(this);
    }

    @Override
    public <R> R accept(Visitor<R> v) {
        return v.visit(this);
    }

    public <A, B> A accept(BinaryVisitor<B, A> v, B parameter) {
        return v.visit(this, parameter);
    }

    @Override
    public Set<Formula> children() {
        return Set.of();
    }

    public int getAtom() {
        return Math.abs(this.index) - 1;
    }

    public boolean isNegated() {
        return this.index < 0;
    }

    @Override
    public boolean isPureEventual() {
        return false;
    }

    @Override
    public boolean isPureUniversal() {
        return false;
    }

    @Override
    public Formula nnf() {
        return this;
    }

    @Override
    public Literal not() {
        return this.negation;
    }

    public String toString() {
        return this.isNegated() ? "!" + this.negation : String.format("p%d", this.index - 1);
    }

    @Override
    public Formula unfold() {
        return this;
    }

    @Override
    public Formula unfoldTemporalStep(BitSet valuation) {
        return this.temporalStep(valuation);
    }

    @Override
    protected int compareToImpl(Formula o) {
        Literal that = (Literal)o;
        int comparison = Integer.compare(this.getAtom(), that.getAtom());
        if (comparison != 0) {
            return comparison;
        }
        return Boolean.compare(this.isNegated(), that.isNegated());
    }

    @Override
    protected boolean equalsImpl(Formula o) {
        Literal that = (Literal)o;
        return this.index == that.index;
    }

    static {
        Arrays.setAll(cache, Literal::new);
    }
}

