/*
 * Decompiled with CFR 0.152.
 */
package owl.ltl;

import java.util.BitSet;
import owl.ltl.BinaryModalOperator;
import owl.ltl.BooleanConstant;
import owl.ltl.Conjunction;
import owl.ltl.Disjunction;
import owl.ltl.FOperator;
import owl.ltl.Formula;
import owl.ltl.ROperator;
import owl.ltl.visitors.BinaryVisitor;
import owl.ltl.visitors.IntVisitor;
import owl.ltl.visitors.Visitor;
import owl.util.annotation.CEntryPoint;

public final class UOperator
extends BinaryModalOperator {
    public UOperator(Formula leftOperand, Formula rightOperand) {
        super(UOperator.class, leftOperand, rightOperand);
    }

    @CEntryPoint
    public static Formula of(Formula leftOperand, Formula rightOperand) {
        if (rightOperand instanceof BooleanConstant || rightOperand instanceof FOperator || leftOperand.equals(rightOperand) || leftOperand.equals(BooleanConstant.FALSE)) {
            return rightOperand;
        }
        if (leftOperand.equals(BooleanConstant.TRUE)) {
            return FOperator.of(rightOperand);
        }
        if (rightOperand instanceof UOperator && leftOperand.equals(((UOperator)rightOperand).left)) {
            return rightOperand;
        }
        return new UOperator(leftOperand, rightOperand);
    }

    @Override
    public int accept(IntVisitor v) {
        return v.visit(this);
    }

    @Override
    public <R> R accept(Visitor<R> v) {
        return v.visit(this);
    }

    public <A, B> A accept(BinaryVisitor<B, A> v, B parameter) {
        return v.visit(this, parameter);
    }

    @Override
    public String operatorSymbol() {
        return "U";
    }

    @Override
    public Formula nnf() {
        return UOperator.of(this.left.nnf(), this.right.nnf());
    }

    @Override
    public Formula not() {
        return ROperator.of(this.left.not(), this.right.not());
    }

    @Override
    public Formula unfold() {
        return Disjunction.of(this.right.unfold(), Conjunction.of(this.left.unfold(), (Formula)this));
    }

    @Override
    public Formula unfoldTemporalStep(BitSet valuation) {
        return Disjunction.of(this.right.unfoldTemporalStep(valuation), Conjunction.of(this.left.unfoldTemporalStep(valuation), (Formula)this));
    }
}

