/*
 * Decompiled with CFR 0.152.
 */
package owl.translations.modules;

import java.util.EnumSet;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Options;
import owl.ltl.LabelledFormula;
import owl.run.modules.InputReaders;
import owl.run.modules.OutputWriters;
import owl.run.modules.OwlModuleParser;
import owl.run.modules.Transformer;
import owl.run.modules.Transformers;
import owl.run.parser.PartialConfigurationParser;
import owl.run.parser.PartialModuleConfiguration;
import owl.translations.ltl2dpa.LTL2DPAFunction;
import owl.translations.modules.AbstractLTL2LDBAModule;

public final class LTL2DPAModule
implements OwlModuleParser.TransformerParser {
    public static final LTL2DPAModule INSTANCE = new LTL2DPAModule();

    private LTL2DPAModule() {
    }

    @Override
    public String getKey() {
        return "ltl2dpa";
    }

    @Override
    public String getDescription() {
        return "Translate LTL to deterministic parity automata, using LDBA constructions.";
    }

    @Override
    public Options getOptions() {
        return new Options().addOption(null, "complement", false, "Compute the automaton also for the negation and return the smaller.").addOptionGroup(AbstractLTL2LDBAModule.getOptionGroup());
    }

    @Override
    public Transformer parse(CommandLine commandLine) {
        EnumSet<LTL2DPAFunction.Configuration> configuration = EnumSet.of(LTL2DPAFunction.Configuration.OPTIMISE_INITIAL_STATE);
        if (commandLine.hasOption("complement")) {
            configuration.add(LTL2DPAFunction.Configuration.COMPLEMENT_CONSTRUCTION_EXACT);
        }
        if (commandLine.hasOption(AbstractLTL2LDBAModule.symmetric().getOpt())) {
            configuration.add(LTL2DPAFunction.Configuration.SYMMETRIC);
        }
        configuration.add(LTL2DPAFunction.Configuration.COMPRESS_COLOURS);
        return environment -> Transformers.instanceFromFunction(LabelledFormula.class, new LTL2DPAFunction(environment, configuration));
    }

    public static void main(String ... args) {
        PartialConfigurationParser.run(args, PartialModuleConfiguration.builder(INSTANCE.getKey()).reader(InputReaders.LTL).addTransformer(Transformers.LTL_SIMPLIFIER).addTransformer(INSTANCE).writer(OutputWriters.HOA).build());
    }
}

