/*
 * Decompiled with CFR 0.152.
 */
package owl.translations.modules;

import org.apache.commons.cli.CommandLine;
import owl.automaton.acceptance.BuchiAcceptance;
import owl.ltl.LabelledFormula;
import owl.run.modules.InputReaders;
import owl.run.modules.OutputWriters;
import owl.run.modules.Transformer;
import owl.run.modules.Transformers;
import owl.run.parser.PartialConfigurationParser;
import owl.run.parser.PartialModuleConfiguration;
import owl.translations.ltl2ldba.AnnotatedLDBA;
import owl.translations.ltl2ldba.AsymmetricLDBAConstruction;
import owl.translations.ltl2ldba.SymmetricLDBAConstruction;
import owl.translations.modules.AbstractLTL2LDBAModule;

public final class LTL2LDBAModule
extends AbstractLTL2LDBAModule {
    public static final LTL2LDBAModule INSTANCE = new LTL2LDBAModule();

    private LTL2LDBAModule() {
    }

    @Override
    public Transformer parse(CommandLine commandLine) {
        if (commandLine.hasOption(LTL2LDBAModule.symmetric().getOpt())) {
            return environment -> Transformers.instanceFromFunction(LabelledFormula.class, SymmetricLDBAConstruction.of(environment, BuchiAcceptance.class).andThen(AnnotatedLDBA::copyAsMutable));
        }
        return environment -> Transformers.instanceFromFunction(LabelledFormula.class, AsymmetricLDBAConstruction.of(environment, BuchiAcceptance.class).andThen(AnnotatedLDBA::copyAsMutable));
    }

    @Override
    public String getKey() {
        return "ltl2ldba";
    }

    @Override
    public String getDescription() {
        return "Translate LTL to limit-deterministic B\u00fcchi automata.";
    }

    public static void main(String ... args) {
        PartialConfigurationParser.run(args, PartialModuleConfiguration.builder(INSTANCE.getKey()).reader(InputReaders.LTL).addTransformer(Transformers.LTL_SIMPLIFIER).addTransformer(INSTANCE).writer(OutputWriters.HOA).build());
    }
}

