/*
 * Decompiled with CFR 0.152.
 */
package de.tum.in.naturals.bitset;

import com.zaxxer.sparsebits.SparseBitSet;
import de.tum.in.naturals.bitset.BitSetComplementIterator;
import de.tum.in.naturals.bitset.BitSetIterator;
import de.tum.in.naturals.bitset.PowerBitSet;
import de.tum.in.naturals.bitset.PowerBitSetSimple;
import de.tum.in.naturals.bitset.SparseBitSets;
import de.tum.in.naturals.set.NatBitSet;
import de.tum.in.naturals.set.NatBitSets;
import it.unimi.dsi.fastutil.ints.IntIterable;
import it.unimi.dsi.fastutil.ints.IntIterator;
import it.unimi.dsi.fastutil.ints.IntSortedSet;
import java.util.BitSet;
import java.util.PrimitiveIterator;
import java.util.Set;
import java.util.function.IntConsumer;

public final class BitSets {
    private BitSets() {
    }

    public static BitSet of(int index) {
        BitSet bitSet = new BitSet(index + 1);
        bitSet.set(index);
        return bitSet;
    }

    public static BitSet of(int ... indices) {
        BitSet bitSet = new BitSet();
        for (int index : indices) {
            bitSet.set(index);
        }
        return bitSet;
    }

    public static BitSet of(IntIterable iterable) {
        IntSortedSet sortedSet;
        if (iterable instanceof NatBitSet) {
            return NatBitSets.toBitSet((NatBitSet)iterable);
        }
        BitSet bitSet = iterable instanceof IntSortedSet ? ((sortedSet = (IntSortedSet)iterable).comparator() == null ? new BitSet(sortedSet.lastInt() + 1) : new BitSet()) : new BitSet();
        iterable.forEach(bitSet::set);
        return bitSet;
    }

    public static BitSet of(Iterable<Integer> iterable) {
        if (iterable instanceof IntIterable) {
            return BitSets.of((IntIterable)iterable);
        }
        BitSet bitSet = new BitSet();
        iterable.forEach(bitSet::set);
        return bitSet;
    }

    public static BitSet of(PrimitiveIterator.OfInt iterator) {
        BitSet bitSet = new BitSet();
        iterator.forEachRemaining(bitSet::set);
        return bitSet;
    }

    public static BitSet of(SparseBitSet sparseBitSet) {
        BitSet bitSet = new BitSet(sparseBitSet.length());
        SparseBitSets.forEach(sparseBitSet, bitSet::set);
        return bitSet;
    }

    public static BitSet copyOf(BitSet bitset) {
        return (BitSet)bitset.clone();
    }

    public static IntIterator complementIterator(BitSet bitSet, int length) {
        return new BitSetComplementIterator(bitSet, length);
    }

    public static void forEach(BitSet bitSet, IntConsumer consumer) {
        int cardinality;
        int length = bitSet.length();
        if (length < (cardinality = bitSet.cardinality()) * 2) {
            int currentBlock = bitSet.nextSetBit(0);
            while (currentBlock > -1) {
                int blockEnd = bitSet.nextClearBit(currentBlock);
                assert (blockEnd > currentBlock);
                for (int i = currentBlock; i < blockEnd; ++i) {
                    consumer.accept(i);
                }
                currentBlock = bitSet.nextSetBit(blockEnd);
            }
        } else {
            int i = bitSet.nextSetBit(0);
            while (i >= 0) {
                consumer.accept(i);
                i = bitSet.nextSetBit(i + 1);
            }
        }
    }

    public static boolean isSubset(BitSet first, BitSet second) {
        int i = first.nextSetBit(0);
        while (i >= 0) {
            if (!second.get(i)) {
                return false;
            }
            i = first.nextSetBit(i + 1);
        }
        return true;
    }

    public static boolean isDisjoint(BitSet first, BitSet second) {
        return !first.intersects(second);
    }

    public static IntIterator iterator(BitSet bitSet) {
        return new BitSetIterator(bitSet);
    }

    public static IntIterator iterator(BitSet bitSet, int length) {
        return new BitSetIterator(bitSet, length);
    }

    public static Set<BitSet> powerSet(BitSet basis) {
        int length = basis.length();
        if (length == basis.cardinality()) {
            return BitSets.powerSet(length);
        }
        return new PowerBitSet(basis);
    }

    public static Set<BitSet> powerSet(int i) {
        return new PowerBitSetSimple(i);
    }
}

