/*
 * Decompiled with CFR 0.152.
 */
package de.tum.in.naturals.set;

import de.tum.in.naturals.set.NatBitSet;
import de.tum.in.naturals.set.NatBitSets;
import de.tum.in.naturals.set.PowerNatBitSetIterator;
import it.unimi.dsi.fastutil.HashCommon;
import it.unimi.dsi.fastutil.Size64;
import it.unimi.dsi.fastutil.ints.IntCollection;
import java.util.AbstractSet;
import java.util.Iterator;
import javax.annotation.Nullable;

class PowerNatBitSet
extends AbstractSet<NatBitSet>
implements Size64 {
    private final NatBitSet baseSet;
    private final int baseSize;

    PowerNatBitSet(NatBitSet baseSet) {
        assert (!baseSet.isEmpty());
        this.baseSet = NatBitSets.compact(baseSet, true);
        this.baseSize = this.baseSet.size();
    }

    @Override
    public boolean contains(@Nullable Object obj) {
        return obj instanceof IntCollection && this.baseSet.containsAll((IntCollection)obj);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof PowerNatBitSet) {
            PowerNatBitSet other = (PowerNatBitSet)obj;
            return this.baseSet.equals(other.baseSet);
        }
        return super.equals(obj);
    }

    @Override
    public int hashCode() {
        return HashCommon.mix((int)this.baseSet.hashCode());
    }

    @Override
    public boolean isEmpty() {
        return false;
    }

    @Override
    public Iterator<NatBitSet> iterator() {
        return new PowerNatBitSetIterator(this.baseSet);
    }

    @Override
    public int size() {
        return this.baseSize >= 32 ? Integer.MAX_VALUE : 1 << this.baseSize;
    }

    public long size64() {
        return 1L << this.baseSize;
    }

    @Override
    public String toString() {
        return String.format("powerSet(%s)", this.baseSet);
    }
}

