/*
 * Decompiled with CFR 0.152.
 */
package de.tum.in.naturals.bitset;

import com.zaxxer.sparsebits.SparseBitSet;
import it.unimi.dsi.fastutil.ints.IntIterator;
import java.util.NoSuchElementException;

class SparseBitSetIterator
implements IntIterator {
    private final SparseBitSet bitSet;
    private final int max;
    private int current = -1;
    private int next;

    SparseBitSetIterator(SparseBitSet bitSet) {
        this(bitSet, Integer.MAX_VALUE);
    }

    SparseBitSetIterator(SparseBitSet bitSet, int max) {
        this.bitSet = bitSet;
        this.max = max;
        this.next = bitSet.nextSetBit(0);
    }

    private int getNext(int index) {
        int next = this.bitSet.nextSetBit(index);
        return next <= this.max ? next : -1;
    }

    public boolean hasNext() {
        return this.next != -1;
    }

    public int nextInt() {
        if (this.next == -1) {
            throw new NoSuchElementException();
        }
        this.current = this.next;
        this.next = this.getNext(this.next + 1);
        return this.current;
    }

    public void remove() {
        if (this.current == -1) {
            throw new IllegalStateException();
        }
        assert (this.bitSet.get(this.current));
        this.bitSet.clear(this.current);
    }
}

