/*
 * Decompiled with CFR 0.152.
 */
package de.tum.in.naturals.set;

import it.unimi.dsi.fastutil.ints.IntIterator;
import java.util.NoSuchElementException;

public class ReverseRangeIterator
implements IntIterator {
    private final int from;
    private int current;

    public ReverseRangeIterator(int from, int to) {
        if (to < from) {
            throw new IllegalArgumentException("To must be larger or equal than from");
        }
        this.from = from;
        this.current = to - 1;
    }

    public boolean hasNext() {
        return this.current >= this.from;
    }

    public int skip(int n) {
        int pos = this.current - n;
        if (pos >= this.from) {
            this.current = pos;
            return n;
        }
        int result = this.current - this.from + 1;
        this.current = this.from - 1;
        return result;
    }

    public int nextInt() {
        if (this.current < this.from) {
            throw new NoSuchElementException();
        }
        int result = this.current--;
        return result;
    }
}

