/*
 * Decompiled with CFR 0.152.
 */
package de.tum.in.jbdd;

final class PrimeTest {
    static final long FLOOR_SQRT_MAX_LONG = 3037000499L;
    private static final int SIEVE_30 = -545925251;
    private static final long[][] millerRabinBaseSets = new long[][]{{291830L, 126401071349994536L}, {885594168L, 725270293939359937L, 3569819667048198375L}, {273919523040L, 15L, 7363882082L, 992620450144556L}, {47636622961200L, 2L, 2570940L, 211991001L, 3749873356L}, {7999252175582850L, 2L, 4130806001517L, 149795463772692060L, 186635894390467037L, 3967304179347715805L}, {585226005592931976L, 2L, 123635709730000L, 9233062284813009L, 43835965440333360L, 761179012939631437L, 1263739024124850375L}, {Long.MAX_VALUE, 2L, 325L, 9375L, 28178L, 450775L, 9780504L, 1795265022L}};

    private PrimeTest() {
    }

    static int compare(long a, long b) {
        return Long.compare(PrimeTest.flip(a), PrimeTest.flip(b));
    }

    static long flip(long a) {
        return a ^ Long.MIN_VALUE;
    }

    static boolean isPrime(long n) {
        assert (n >= 0L);
        if (n < 2L) {
            return false;
        }
        if (n == 2L || n == 3L || n == 5L || n == 7L || n == 11L || n == 13L) {
            return true;
        }
        if ((0xDF75D77D & 1 << (int)(n % 30L)) != 0) {
            return false;
        }
        if (n % 7L == 0L || n % 11L == 0L || n % 13L == 0L) {
            return false;
        }
        if (n < 289L) {
            return true;
        }
        for (long[] baseSet : millerRabinBaseSets) {
            if (n > baseSet[0]) continue;
            for (int i = 1; i < baseSet.length; ++i) {
                if (MillerRabinTester.test(baseSet[i], n)) continue;
                return false;
            }
            return true;
        }
        throw new AssertionError();
    }

    static long remainder(long dividend, long divisor) {
        long rem;
        if (divisor < 0L) {
            if (PrimeTest.compare(dividend, divisor) < 0) {
                return dividend;
            }
            return dividend - divisor;
        }
        if (dividend >= 0L) {
            return dividend % divisor;
        }
        long quotient = (dividend >>> 1) / divisor << 1;
        return rem - (PrimeTest.compare(rem = dividend - quotient * divisor, divisor) >= 0 ? divisor : 0L);
    }

    private static enum MillerRabinTester {
        SMALL{

            @Override
            long mulMod(long a, long b, long m) {
                return a * b % m;
            }

            @Override
            long squareMod(long a, long m) {
                return a * a % m;
            }
        }
        ,
        LARGE{

            private long plusMod(long a, long b, long m) {
                return a >= m - b ? a + b - m : a + b;
            }

            private long times2ToThe32Mod(long a, long m) {
                int shift;
                int remainingPowersOf2 = 32;
                do {
                    shift = Math.min(remainingPowersOf2, Long.numberOfLeadingZeros(a));
                    a = PrimeTest.remainder(a << shift, m);
                } while ((remainingPowersOf2 -= shift) > 0);
                return a;
            }

            @Override
            long mulMod(long a, long b, long m) {
                long aHi = a >>> 32;
                long bHi = b >>> 32;
                long aLo = a & 0xFFFFFFFFL;
                long bLo = b & 0xFFFFFFFFL;
                long result = this.times2ToThe32Mod(aHi * bHi, m);
                if ((result += aHi * bLo) < 0L) {
                    result = PrimeTest.remainder(result, m);
                }
                result += aLo * bHi;
                result = this.times2ToThe32Mod(result, m);
                return this.plusMod(result, PrimeTest.remainder(aLo * bLo, m), m);
            }

            @Override
            long squareMod(long a, long m) {
                long aHi = a >>> 32;
                long aLo = a & 0xFFFFFFFFL;
                long result = this.times2ToThe32Mod(aHi * aHi, m);
                long hiLo = aHi * aLo * 2L;
                if (hiLo < 0L) {
                    hiLo = PrimeTest.remainder(hiLo, m);
                }
                result += hiLo;
                result = this.times2ToThe32Mod(result, m);
                return this.plusMod(result, PrimeTest.remainder(aLo * aLo, m), m);
            }
        };


        static boolean test(long base, long n) {
            return (n <= 3037000499L ? SMALL : LARGE).testWitness(base, n);
        }

        abstract long mulMod(long var1, long var3, long var5);

        private long powMod(long a, long p, long m) {
            long res = 1L;
            while (p != 0L) {
                if ((p & 1L) != 0L) {
                    res = this.mulMod(res, a, m);
                }
                a = this.squareMod(a, m);
                p >>= 1;
            }
            return res;
        }

        abstract long squareMod(long var1, long var3);

        private boolean testWitness(long base, long n) {
            int r = Long.numberOfTrailingZeros(n - 1L);
            long d = n - 1L >> r;
            if ((base %= n) == 0L) {
                return true;
            }
            long a = this.powMod(base, d, n);
            if (a == 1L) {
                return true;
            }
            int j = 0;
            while (a != n - 1L) {
                if (++j == r) {
                    return false;
                }
                a = this.squareMod(a, n);
            }
            return true;
        }
    }
}

