/*
 * Decompiled with CFR 0.152.
 */
package owl.automaton;

import com.google.common.base.Preconditions;
import de.tum.in.naturals.bitset.BitSets;
import java.util.BitSet;
import java.util.Collection;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.Function;
import javax.annotation.Nullable;
import owl.automaton.AbstractImplicitAutomaton;
import owl.automaton.Automaton;
import owl.automaton.EdgeMapAutomatonMixin;
import owl.automaton.ImplicitNonDeterministicEdgeMapAutomaton;
import owl.automaton.ImplicitSemiDeterministicEdgesAutomaton;
import owl.automaton.acceptance.NoneAcceptance;
import owl.automaton.acceptance.OmegaAcceptance;
import owl.automaton.edge.Edge;
import owl.collections.ValuationSet;
import owl.factories.ValuationSetFactory;

public final class AutomatonFactory {
    private AutomatonFactory() {
    }

    public static <S, A extends OmegaAcceptance> Automaton<S, A> create(ValuationSetFactory factory, S initialState, A acceptance, BiFunction<S, BitSet, Edge<S>> transitions) {
        return AutomatonFactory.create(factory, Set.of(initialState), acceptance, transitions);
    }

    public static <S, A extends OmegaAcceptance> Automaton<S, A> create(ValuationSetFactory factory, Collection<S> initialStates, A acceptance, BiFunction<S, BitSet, Edge<S>> transitions) {
        return new ImplicitSemiDeterministicEdgesAutomaton<S, A>(factory, initialStates, acceptance, transitions);
    }

    public static <S, A extends OmegaAcceptance> Automaton<S, A> create(ValuationSetFactory factory, S initialState, A acceptance, Function<S, Map<Edge<S>, ValuationSet>> labelledEdgesFunction) {
        return AutomatonFactory.create(factory, Set.of(initialState), acceptance, labelledEdgesFunction);
    }

    public static <S, A extends OmegaAcceptance> Automaton<S, A> create(ValuationSetFactory factory, S initialState, A acceptance, BiFunction<S, BitSet, Set<Edge<S>>> edgesFunction, Function<S, Map<Edge<S>, ValuationSet>> labelledEdgesFunction) {
        return AutomatonFactory.create(factory, Set.of(initialState), acceptance, edgesFunction, labelledEdgesFunction);
    }

    public static <S, A extends OmegaAcceptance> Automaton<S, A> create(ValuationSetFactory factory, Collection<S> initialStates, A acceptance, Function<S, Map<Edge<S>, ValuationSet>> labelledEdgesFunction) {
        return new ImplicitNonDeterministicEdgeMapAutomaton<S, A>(factory, initialStates, acceptance, null, labelledEdgesFunction);
    }

    public static <S, A extends OmegaAcceptance> Automaton<S, A> create(ValuationSetFactory factory, Collection<S> initialStates, A acceptance, BiFunction<S, BitSet, Set<Edge<S>>> edgesFunction, Function<S, ? extends Map<Edge<S>, ValuationSet>> labelledEdgesFunction) {
        return new ImplicitNonDeterministicEdgeMapAutomaton<S, A>(factory, initialStates, acceptance, Objects.requireNonNull(edgesFunction), labelledEdgesFunction);
    }

    public static <S> Automaton<S, NoneAcceptance> empty(ValuationSetFactory factory) {
        return AutomatonFactory.empty(factory, NoneAcceptance.INSTANCE);
    }

    public static <S, A extends OmegaAcceptance> Automaton<S, A> empty(ValuationSetFactory factory, A acceptance) {
        return new EmptyAutomaton(factory, acceptance);
    }

    public static <S, A extends OmegaAcceptance> Automaton<S, A> singleton(ValuationSetFactory factory, S state, A acceptance) {
        return new SingletonAutomaton<S, A>(state, factory, null, acceptance);
    }

    public static <S, A extends OmegaAcceptance> Automaton<S, A> singleton(ValuationSetFactory factory, S state, A acceptance, Set<Integer> acceptanceSet) {
        return new SingletonAutomaton<S, A>(state, factory, BitSets.of(acceptanceSet), acceptance);
    }

    public static <S, A extends OmegaAcceptance> Automaton<S, A> singleton(ValuationSetFactory factory, S state, A acceptance, BitSet acceptanceSet) {
        return new SingletonAutomaton<S, A>(state, factory, acceptanceSet, acceptance);
    }

    private static final class SingletonAutomaton<S, A extends OmegaAcceptance>
    extends AbstractImplicitAutomaton<S, A>
    implements EdgeMapAutomatonMixin<S, A> {
        private final Map<Edge<S>, ValuationSet> selfLoopEdges;

        private SingletonAutomaton(S singletonState, ValuationSetFactory factory, @Nullable BitSet acceptanceSets, A acceptance) {
            super(factory, Set.of(singletonState), acceptance);
            this.selfLoopEdges = acceptanceSets == null ? Map.of() : Map.of(Edge.of(singletonState, acceptanceSets), factory.universe());
        }

        @Override
        public Map<Edge<S>, ValuationSet> edgeMap(S state) {
            Preconditions.checkArgument((boolean)this.initialStates.contains(state), (Object)"This state is not in the automaton");
            return this.selfLoopEdges;
        }
    }

    private static final class EmptyAutomaton<S, A extends OmegaAcceptance>
    extends AbstractImplicitAutomaton<S, A>
    implements EdgeMapAutomatonMixin<S, A> {
        private EmptyAutomaton(ValuationSetFactory factory, A acceptance) {
            super(factory, Set.of(), acceptance);
        }

        @Override
        public Map<Edge<S>, ValuationSet> edgeMap(S state) {
            throw new IllegalArgumentException("There are no states in this automaton.");
        }
    }
}

