/*
 * Decompiled with CFR 0.152.
 */
package owl.cinterface;

import java.util.BitSet;
import java.util.Set;
import java.util.stream.Collectors;
import owl.ltl.BooleanConstant;
import owl.ltl.Formula;
import owl.ltl.Literal;
import owl.ltl.SyntacticFragment;
import owl.ltl.visitors.Converter;

class RealizabilityRewriter {
    private RealizabilityRewriter() {
    }

    static Formula removeSingleValuedInputLiterals(BitSet inputVariables, Formula formula) {
        Set<Literal> atoms;
        Set<Literal> singleAtoms;
        Formula oldFormula;
        if (!SyntacticFragment.NNF.contains(formula)) {
            return formula;
        }
        Formula newFormula = formula;
        while (!(oldFormula = newFormula).equals(newFormula = oldFormula.accept(new InputLiteralSimplifier(singleAtoms = (atoms = formula.subformulas(Literal.class)).stream().filter(x -> inputVariables.get(x.getAtom()) && !atoms.contains(x.not())).collect(Collectors.toSet()))))) {
        }
        return newFormula;
    }

    private static class InputLiteralSimplifier
    extends Converter {
        private final Set<Literal> singleValuedInputVariables;

        private InputLiteralSimplifier(Set<Literal> singleValuedInputVariables) {
            super(SyntacticFragment.NNF);
            this.singleValuedInputVariables = singleValuedInputVariables;
        }

        @Override
        public Formula visit(Literal literal) {
            if (this.singleValuedInputVariables.contains(literal)) {
                return BooleanConstant.FALSE;
            }
            return literal;
        }
    }
}

