/*
 * Decompiled with CFR 0.152.
 */
package owl.translations;

import java.util.EnumSet;
import java.util.Set;
import java.util.function.Function;
import owl.automaton.Automaton;
import owl.automaton.acceptance.AllAcceptance;
import owl.automaton.acceptance.BuchiAcceptance;
import owl.automaton.acceptance.GeneralizedBuchiAcceptance;
import owl.factories.Factories;
import owl.ltl.Conjunction;
import owl.ltl.Formula;
import owl.ltl.LabelledFormula;
import owl.ltl.SyntacticFragment;
import owl.ltl.SyntacticFragments;
import owl.ltl.XOperator;
import owl.run.Environment;
import owl.translations.canonical.GenericConstructions;
import owl.translations.canonical.NonDeterministicConstructions;
import owl.translations.canonical.RoundRobinState;
import owl.translations.ltl2nba.SymmetricNBAConstruction;

public final class LTL2NAFunction
implements Function<LabelledFormula, Automaton<?, ?>> {
    private final Environment environment;
    private final EnumSet<Constructions> allowedConstructions;
    private final Function<LabelledFormula, ? extends Automaton<?, ?>> fallback;

    public LTL2NAFunction(Environment environment) {
        this(environment, EnumSet.allOf(Constructions.class));
    }

    public LTL2NAFunction(Environment environment, EnumSet<Constructions> allowedConstructions) {
        this.allowedConstructions = EnumSet.copyOf(allowedConstructions);
        this.environment = environment;
        this.fallback = this.allowedConstructions.contains((Object)Constructions.GENERALIZED_BUCHI) ? SymmetricNBAConstruction.of(environment, GeneralizedBuchiAcceptance.class) : (this.allowedConstructions.contains((Object)Constructions.BUCHI) ? SymmetricNBAConstruction.of(environment, BuchiAcceptance.class) : x -> {
            throw new IllegalArgumentException("All allowed constructions exhausted.");
        });
    }

    @Override
    public Automaton<?, ?> apply(LabelledFormula formula) {
        if (this.allowedConstructions.contains((Object)Constructions.SAFETY) && SyntacticFragment.SAFETY.contains(formula)) {
            return LTL2NAFunction.safety(this.environment, formula);
        }
        if (this.allowedConstructions.contains((Object)Constructions.CO_SAFETY) && SyntacticFragment.CO_SAFETY.contains(formula)) {
            return LTL2NAFunction.coSafety(this.environment, formula);
        }
        if (formula.formula() instanceof XOperator) {
            int xCount = 0;
            Formula unwrappedFormula = formula.formula();
            while (unwrappedFormula instanceof XOperator) {
                ++xCount;
                unwrappedFormula = ((XOperator)unwrappedFormula).operand;
            }
            return GenericConstructions.delay(this.apply(formula.wrap(unwrappedFormula)), xCount);
        }
        if (this.allowedConstructions.contains((Object)Constructions.BUCHI) || this.allowedConstructions.contains((Object)Constructions.GENERALIZED_BUCHI)) {
            Set<Formula> formulas;
            Set<Formula> set = formulas = formula.formula() instanceof Conjunction ? formula.formula().children() : Set.of(formula.formula());
            if (formulas.stream().allMatch(SyntacticFragments::isGfCoSafety)) {
                return LTL2NAFunction.gfCoSafety(this.environment, formula, this.allowedConstructions.contains((Object)Constructions.GENERALIZED_BUCHI));
            }
            if (SyntacticFragments.isFgSafety(formula.formula())) {
                return LTL2NAFunction.fgSafety(this.environment, formula);
            }
        }
        return this.fallback.apply(formula);
    }

    static Automaton<Formula, BuchiAcceptance> coSafety(Environment environment, LabelledFormula formula) {
        Factories factories = environment.factorySupplier().getFactories(formula.variables(), false);
        return new NonDeterministicConstructions.CoSafety(factories, formula.formula());
    }

    static Automaton<Formula, AllAcceptance> safety(Environment environment, LabelledFormula formula) {
        Factories factories = environment.factorySupplier().getFactories(formula.variables(), false);
        return new NonDeterministicConstructions.Safety(factories, formula.formula());
    }

    static Automaton<RoundRobinState<Formula>, GeneralizedBuchiAcceptance> gfCoSafety(Environment environment, LabelledFormula formula, boolean generalized) {
        Factories factories = environment.factorySupplier().getFactories(formula.variables(), false);
        Set<Formula> formulas = formula.formula() instanceof Conjunction ? formula.formula().children() : Set.of(formula.formula());
        return new NonDeterministicConstructions.GfCoSafety(factories, formulas, generalized);
    }

    static Automaton<Formula, BuchiAcceptance> fgSafety(Environment environment, LabelledFormula formula) {
        Factories factories = environment.factorySupplier().getFactories(formula.variables(), false);
        return new NonDeterministicConstructions.FgSafety(factories, formula.formula());
    }

    public static enum Constructions {
        SAFETY,
        CO_SAFETY,
        BUCHI,
        GENERALIZED_BUCHI;

    }
}

