/*
 * Decompiled with CFR 0.152.
 */
package owl.translations.ltl2dpa;

import com.google.common.base.Preconditions;
import java.util.List;
import java.util.Map;
import org.immutables.value.Value;
import owl.automaton.util.AnnotatedState;
import owl.collections.Collections3;
import owl.ltl.EquivalenceClass;
import owl.translations.ltl2dpa.SymmetricRankingStateTuple;
import owl.translations.ltl2ldba.SymmetricProductState;
import owl.util.annotation.HashedTuple;

@Value.Immutable
@HashedTuple
abstract class SymmetricRankingState
implements AnnotatedState<Map<Integer, EquivalenceClass>> {
    SymmetricRankingState() {
    }

    @Override
    public abstract Map<Integer, EquivalenceClass> state();

    abstract List<SymmetricProductState> ranking();

    abstract int safetyBucket();

    abstract int safetyBucketIndex();

    static SymmetricRankingState of(Map<Integer, EquivalenceClass> state) {
        return SymmetricRankingState.of(state, List.of(), 0, -1);
    }

    static SymmetricRankingState of(Map<Integer, EquivalenceClass> state, List<SymmetricProductState> ranking, int safetyBucket, int safetyBucketIndex) {
        assert (Collections3.isDistinct(ranking)) : "The following list is not distinct: " + ranking;
        return SymmetricRankingStateTuple.create(state, ranking, safetyBucket, safetyBucketIndex);
    }

    @Value.Check
    protected void check() {
        Preconditions.checkState((this.safetyBucket() == 0 && this.safetyBucketIndex() == -1 || this.safetyBucket() > 0 && this.safetyBucketIndex() >= 0 ? 1 : 0) != 0);
        Preconditions.checkState((this.safetyBucket() == 0 || this.state().containsKey(this.safetyBucket()) ? 1 : 0) != 0);
    }

    public String toString() {
        if (this.safetyBucket() == 0) {
            return String.format("|%s :: %s|", this.state(), this.ranking());
        }
        return String.format("|%s :: %s :: %d (%d)|", this.state(), this.ranking(), this.safetyBucket(), this.safetyBucketIndex());
    }
}

