/*
 * Decompiled with CFR 0.152.
 */
package owl.translations.modules;

import org.apache.commons.cli.CommandLine;
import owl.automaton.acceptance.GeneralizedRabinAcceptance;
import owl.ltl.LabelledFormula;
import owl.run.modules.InputReaders;
import owl.run.modules.OutputWriters;
import owl.run.modules.Transformer;
import owl.run.modules.Transformers;
import owl.run.parser.PartialConfigurationParser;
import owl.run.parser.PartialModuleConfiguration;
import owl.translations.ltl2dra.SymmetricDRAConstruction;
import owl.translations.modules.AbstractLTL2DRAModule;
import owl.translations.rabinizer.RabinizerBuilder;
import owl.translations.rabinizer.RabinizerConfiguration;

public final class LTL2DGRAModule
extends AbstractLTL2DRAModule {
    public static final LTL2DGRAModule INSTANCE = new LTL2DGRAModule();

    private LTL2DGRAModule() {
    }

    @Override
    public String getKey() {
        return "ltl2dgra";
    }

    @Override
    public String getDescription() {
        return "Translate LTL to deterministic generalized Rabin automata using either a symmetric construction (default) based on a unified approach using the Master Theorem or an asymmetric construction, also known as the \"Rabinizer construction\".";
    }

    @Override
    public Transformer parse(CommandLine commandLine) {
        RabinizerConfiguration configuration = LTL2DGRAModule.parseAsymmetric(commandLine);
        if (configuration == null) {
            return environment -> Transformers.instanceFromFunction(LabelledFormula.class, SymmetricDRAConstruction.of(environment, GeneralizedRabinAcceptance.class, true));
        }
        return environment -> Transformers.instanceFromFunction(LabelledFormula.class, formula -> RabinizerBuilder.build(formula, environment, configuration));
    }

    public static void main(String ... args) {
        PartialConfigurationParser.run(args, PartialModuleConfiguration.builder("ltl2dgra").reader(InputReaders.LTL).addTransformer(Transformers.LTL_SIMPLIFIER).addTransformer(INSTANCE).addTransformer(Transformers.MINIMIZER).writer(OutputWriters.HOA).build());
    }
}

