/*
 * Decompiled with CFR 0.152.
 */
package owl.automaton.edge;

import de.tum.in.naturals.NaturalsTransformer;
import de.tum.in.naturals.bitset.BitSets;
import de.tum.in.naturals.bitset.ImmutableBitSet;
import java.util.BitSet;
import java.util.Objects;
import java.util.PrimitiveIterator;
import java.util.function.IntUnaryOperator;
import javax.annotation.Nonnegative;
import owl.automaton.edge.EdgeGeneric;
import owl.automaton.edge.EdgeLong;
import owl.automaton.edge.EdgeSingleton;

public abstract class Edge<S> {
    final S successor;

    Edge(S successor) {
        this.successor = Objects.requireNonNull(successor);
    }

    public static <S> Edge<S> of(S successor) {
        return new EdgeSingleton<S>(successor);
    }

    public static <S> Edge<S> of(S successor, @Nonnegative int acceptance) {
        return new EdgeSingleton<S>(successor, acceptance);
    }

    public static <S> Edge<S> of(S successor, BitSet acceptance) {
        if (acceptance.isEmpty()) {
            return Edge.of(successor);
        }
        if (acceptance.cardinality() == 1) {
            return Edge.of(successor, acceptance.nextSetBit(0));
        }
        if (acceptance.length() <= 64) {
            return new EdgeLong<S>(successor, acceptance);
        }
        return new EdgeGeneric<S>(successor, (BitSet)ImmutableBitSet.copyOf((BitSet)acceptance));
    }

    public abstract PrimitiveIterator.OfInt acceptanceSetIterator();

    public final S successor() {
        return this.successor;
    }

    public abstract boolean hasAcceptanceSets();

    public abstract boolean inSet(@Nonnegative int var1);

    public abstract int largestAcceptanceSet();

    public abstract int smallestAcceptanceSet();

    public Edge<S> withAcceptance(int i) {
        return Edge.of(this.successor(), i);
    }

    public Edge<S> withAcceptance(BitSet acceptance) {
        return Edge.of(this.successor(), acceptance);
    }

    public Edge<S> withAcceptance(IntUnaryOperator transformer) {
        NaturalsTransformer iter = new NaturalsTransformer(this.acceptanceSetIterator(), transformer);
        if (!iter.hasNext()) {
            return this.withoutAcceptance();
        }
        int first = iter.nextInt();
        if (!iter.hasNext()) {
            return Edge.of(this.successor(), first);
        }
        BitSet acceptanceSet = BitSets.of((PrimitiveIterator.OfInt)iter);
        acceptanceSet.set(first);
        return this.withAcceptance(acceptanceSet);
    }

    public Edge<S> withoutAcceptance() {
        return Edge.of(this.successor());
    }

    public abstract <T> Edge<T> withSuccessor(T var1);

    public String toString() {
        PrimitiveIterator.OfInt acceptanceSetIterator = this.acceptanceSetIterator();
        StringBuilder builder = new StringBuilder(10);
        builder.append(acceptanceSetIterator.nextInt());
        acceptanceSetIterator.forEachRemaining(x -> builder.append(", ").append(x));
        return "-> " + this.successor + " {" + builder + "}";
    }
}

