/*
 * Decompiled with CFR 0.152.
 */
package owl.automaton.transformations;

import com.google.common.collect.HashBasedTable;
import com.google.common.collect.Iterables;
import com.google.common.collect.Sets;
import com.google.common.collect.Table;
import com.google.common.primitives.ImmutableIntArray;
import de.tum.in.naturals.Indices;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntIterator;
import it.unimi.dsi.fastutil.ints.IntIterators;
import it.unimi.dsi.fastutil.ints.IntList;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import org.immutables.value.Value;
import owl.automaton.Automaton;
import owl.automaton.AutomatonFactory;
import owl.automaton.AutomatonUtil;
import owl.automaton.MutableAutomaton;
import owl.automaton.MutableAutomatonFactory;
import owl.automaton.SuccessorFunction;
import owl.automaton.acceptance.GeneralizedRabinAcceptance;
import owl.automaton.acceptance.RabinAcceptance;
import owl.automaton.algorithms.SccDecomposition;
import owl.automaton.edge.Edge;
import owl.automaton.transformations.DegeneralizedRabinStateTuple;
import owl.automaton.util.AnnotatedState;
import owl.collections.ValuationSet;
import owl.run.PipelineExecutionContext;
import owl.run.modules.ImmutableTransformerParser;
import owl.run.modules.OwlModuleParser;
import owl.run.modules.Transformers;
import owl.util.annotation.HashedTuple;

public final class RabinDegeneralization
extends Transformers.SimpleTransformer {
    public static final RabinDegeneralization INSTANCE = new RabinDegeneralization();
    public static final OwlModuleParser.TransformerParser CLI = ImmutableTransformerParser.builder().key("dgra2dra").description("Converts a generalized Rabin automaton into a regular one").parser(settings -> environment -> INSTANCE).build();
    private static final Logger logger = Logger.getLogger(RabinDegeneralization.class.getName());

    public static <S> Automaton<?, RabinAcceptance> degeneralize(Automaton<S, ? extends GeneralizedRabinAcceptance> automaton) {
        if (automaton.acceptance() instanceof RabinAcceptance) {
            return AutomatonUtil.cast(automaton, RabinAcceptance.class);
        }
        if (logger.isLoggable(Level.FINER)) {
            logger.log(Level.FINER, "De-generalising automaton with " + automaton.size() + " states");
        }
        ArrayList trackedPairs = new ArrayList();
        ArrayList noInfPairs = new ArrayList();
        automaton.acceptance().pairs().forEach(pair -> {
            if (pair.hasInfSet()) {
                trackedPairs.add(pair);
            } else {
                noInfPairs.add(pair);
            }
        });
        int trackedPairsCount = trackedPairs.size();
        int rabinCount = trackedPairsCount + noInfPairs.size();
        RabinAcceptance rabinAcceptance = RabinAcceptance.of(rabinCount);
        HashMap<Object, DegeneralizedRabinState<Object>> stateMap = new HashMap<Object, DegeneralizedRabinState<Object>>();
        HashBasedTable transientEdgesTable = HashBasedTable.create();
        MutableAutomaton<DegeneralizedRabinState, RabinAcceptance> resultAutomaton = MutableAutomatonFactory.create(rabinAcceptance, automaton.factory());
        for (Set<S> scc : SccDecomposition.computeSccs(automaton, true)) {
            if (SccDecomposition.isTransient(automaton::successors, scc)) {
                Object state2 = Iterables.getOnlyElement(scc);
                assert (!stateMap.containsKey(state2));
                DegeneralizedRabinState<Object> degeneralizedState = DegeneralizedRabinState.of(state2);
                resultAutomaton.addInitialState(degeneralizedState);
                stateMap.put(state2, degeneralizedState);
                Map successors2 = transientEdgesTable.row(degeneralizedState);
                automaton.edgeMap(state2).forEach((edge, valuations) -> successors2.merge(edge.successor(), valuations, ValuationSet::union));
                continue;
            }
            BitSet indices = AutomatonUtil.getAcceptanceSets(automaton, scc);
            IntArrayList sccTrackedPairs = new IntArrayList(trackedPairsCount);
            Indices.forEachIndexed(trackedPairs, (arg_0, arg_1) -> RabinDegeneralization.lambda$degeneralize$4(indices, (IntList)sccTrackedPairs, arg_0, arg_1));
            assert (sccTrackedPairs.size() <= trackedPairsCount);
            DegeneralizedRabinState<S> initialSccState = DegeneralizedRabinState.of(scc.iterator().next(), new int[sccTrackedPairs.size()]);
            Automaton<DegeneralizedRabinState, RabinAcceptance> sourceAutomaton = AutomatonFactory.create(resultAutomaton.factory(), initialSccState, (RabinAcceptance)resultAutomaton.acceptance(), arg_0 -> RabinDegeneralization.lambda$degeneralize$7((Table)transientEdgesTable, automaton, scc, (IntList)sccTrackedPairs, rabinCount, trackedPairs, rabinAcceptance, noInfPairs, trackedPairsCount, arg_0));
            MutableAutomatonFactory.copy(sourceAutomaton, resultAutomaton);
            Set resultBscc = SccDecomposition.computeSccs(SuccessorFunction.filter(resultAutomaton, sourceAutomaton.states()), sourceAutomaton.states(), false).stream().filter(resultScc -> SccDecomposition.isTrap(resultAutomaton, resultScc)).findAny().orElseThrow();
            if (!resultBscc.isEmpty()) {
                resultAutomaton.addInitialState((DegeneralizedRabinState)resultBscc.iterator().next());
            }
            Sets.SetView transientStates = Sets.difference(sourceAutomaton.states(), (Set)resultBscc);
            resultAutomaton.removeStateIf(arg_0 -> transientStates.contains(arg_0));
            resultAutomaton.trim();
            resultBscc.forEach(state -> stateMap.putIfAbsent(state.state(), (DegeneralizedRabinState<Object>)state));
        }
        assert (stateMap.keySet().equals(automaton.states()));
        transientEdgesTable.rowMap().forEach((state, successors) -> successors.forEach((generalizedSuccessor, valuations) -> {
            DegeneralizedRabinState successor = (DegeneralizedRabinState)stateMap.get(generalizedSuccessor);
            resultAutomaton.addState((DegeneralizedRabinState)state);
            resultAutomaton.addEdge((DegeneralizedRabinState)state, (ValuationSet)valuations, Edge.of(successor));
        }));
        resultAutomaton.initialStates(automaton.initialStates().stream().map(stateMap::get).collect(Collectors.toList()));
        resultAutomaton.trim();
        return resultAutomaton;
    }

    @Override
    public Object transform(Object object, PipelineExecutionContext context) {
        return RabinDegeneralization.degeneralize(AutomatonUtil.cast(object, GeneralizedRabinAcceptance.class));
    }

    private static /* synthetic */ Map lambda$degeneralize$7(Table transientEdgesTable, Automaton automaton, Set scc, IntList sccTrackedPairs, int rabinCount, List trackedPairs, RabinAcceptance rabinAcceptance, List noInfPairs, int trackedPairsCount, DegeneralizedRabinState state) {
        Object generalizedState = state.state();
        Map transientSuccessors = transientEdgesTable.row((Object)state);
        HashMap successors = new HashMap();
        automaton.edgeMap(generalizedState).forEach((edge, valuation) -> {
            Object generalizedSuccessor = edge.successor();
            if (!scc.contains(generalizedSuccessor)) {
                transientSuccessors.merge(generalizedSuccessor, valuation, ValuationSet::union);
                return;
            }
            int[] successorAwaitedIndices = new int[sccTrackedPairs.size()];
            BitSet edgeAcceptance = new BitSet(rabinCount);
            for (int sccPairIndex = 0; sccPairIndex < sccTrackedPairs.size(); ++sccPairIndex) {
                int currentPairIndex = sccTrackedPairs.getInt(sccPairIndex);
                GeneralizedRabinAcceptance.RabinPair currentPair = (GeneralizedRabinAcceptance.RabinPair)trackedPairs.get(currentPairIndex);
                int awaitedInfSet = state.awaitedInfSet(sccPairIndex);
                if (edge.inSet(currentPair.finSet())) {
                    awaitedInfSet = 0;
                    edgeAcceptance.set(rabinAcceptance.pairs().get(currentPairIndex).finSet());
                } else {
                    int currentInfIndex;
                    int infiniteIndexCount = currentPair.infSetCount();
                    int currentInfNumber = awaitedInfSet;
                    for (int i = 0; i < infiniteIndexCount && edge.inSet(currentInfIndex = currentPair.infSet(currentInfNumber = (awaitedInfSet + i) % infiniteIndexCount)); ++i) {
                        if (currentInfNumber != infiniteIndexCount - 1) continue;
                        edgeAcceptance.set(rabinAcceptance.pairs().get(currentPairIndex).infSet());
                    }
                    awaitedInfSet = currentInfNumber;
                }
                successorAwaitedIndices[sccPairIndex] = awaitedInfSet;
            }
            Indices.forEachIndexed((Iterable)noInfPairs, (noInfIndex, pair) -> {
                int currentPairIndex = trackedPairsCount + noInfIndex;
                GeneralizedRabinAcceptance.RabinPair currentPair = rabinAcceptance.pairs().get(currentPairIndex);
                edgeAcceptance.set(edge.inSet(pair.finSet()) ? currentPair.finSet() : currentPair.infSet());
            });
            DegeneralizedRabinState successor = DegeneralizedRabinState.of(generalizedSuccessor, successorAwaitedIndices);
            successors.merge(Edge.of(successor, edgeAcceptance), valuation, ValuationSet::union);
        });
        return successors;
    }

    private static /* synthetic */ void lambda$degeneralize$4(BitSet indices, IntList sccTrackedPairs, int pairIndex, GeneralizedRabinAcceptance.RabinPair pair) {
        assert (pair.hasInfSet());
        if (IntIterators.all((IntIterator)pair.infSetIterator(), indices::get)) {
            sccTrackedPairs.add(pairIndex);
        }
    }

    @Value.Immutable
    @HashedTuple
    static abstract class DegeneralizedRabinState<S>
    implements AnnotatedState<S> {
        DegeneralizedRabinState() {
        }

        @Override
        public abstract S state();

        public abstract ImmutableIntArray awaitedSets();

        static <S> DegeneralizedRabinState<S> of(S state) {
            return DegeneralizedRabinStateTuple.create(state, ImmutableIntArray.of());
        }

        static <S> DegeneralizedRabinState<S> of(S state, int[] awaitedSets) {
            return DegeneralizedRabinStateTuple.create(state, ImmutableIntArray.copyOf((int[])awaitedSets));
        }

        int awaitedInfSet(int generalizedPairIndex) {
            return this.awaitedSets().get(generalizedPairIndex);
        }

        public String toString() {
            return this.awaitedSets().isEmpty() ? String.format("{%s}", this.state()) : String.format("{%s|%s}", this.state(), this.awaitedSets());
        }
    }
}

