/*
 * Decompiled with CFR 0.152.
 */
package owl.collections;

import com.google.common.base.Preconditions;
import com.google.common.collect.Iterables;
import java.util.AbstractList;
import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.BiPredicate;
import java.util.function.Function;
import javax.annotation.Nullable;
import owl.collections.ValuationSet;

public final class Collections3 {
    private Collections3() {
    }

    public static <E> List<E> add(final List<E> list, final E element) {
        if (list.isEmpty()) {
            return List.of(element);
        }
        return new AbstractList<E>(){

            @Override
            public boolean contains(Object o) {
                return element.equals(o) || list.contains(o);
            }

            @Override
            public boolean isEmpty() {
                return false;
            }

            @Override
            public E get(int index) {
                int size = list.size();
                Objects.checkIndex(index, size + 1);
                return index == size ? element : list.get(index);
            }

            @Override
            public int size() {
                return list.size() + 1;
            }
        };
    }

    public static <K, V> Map<K, V> add(final Map<K, V> map, final K key, final V value) {
        Preconditions.checkArgument((!map.containsKey(key) ? 1 : 0) != 0, (Object)("duplicate key: " + key));
        if (map.isEmpty()) {
            return Map.of(key, value);
        }
        return new AbstractMap<K, V>(){

            @Override
            public boolean containsKey(Object otherKey) {
                return key.equals(otherKey) || map.containsKey(otherKey);
            }

            @Override
            public boolean containsValue(Object otherValue) {
                return value.equals(otherValue) || map.containsValue(otherValue);
            }

            @Override
            public Set<Map.Entry<K, V>> entrySet() {
                return Collections3.add(map.entrySet(), Map.entry(key, value));
            }

            @Override
            public V get(Object otherKey) {
                return key.equals(otherKey) ? value : map.get(otherKey);
            }

            @Override
            public boolean isEmpty() {
                return false;
            }

            @Override
            public Set<K> keySet() {
                return Collections3.add(map.keySet(), key);
            }

            @Override
            public int size() {
                return map.size() + 1;
            }
        };
    }

    public static <E> Set<E> add(final Set<E> set, final E element) {
        if (set.contains(element)) {
            return set;
        }
        if (set.isEmpty()) {
            return Set.of(element);
        }
        return new AbstractSet<E>(){

            @Override
            public boolean contains(Object o) {
                return set.contains(o) || element.equals(o);
            }

            @Override
            public boolean isEmpty() {
                return false;
            }

            @Override
            public Iterator<E> iterator() {
                return new Iterator<E>(){
                    Iterator<E> iterator;
                    boolean elementReturned;
                    {
                        this.iterator = set.iterator();
                        this.elementReturned = false;
                    }

                    @Override
                    public boolean hasNext() {
                        return this.iterator.hasNext() || !this.elementReturned;
                    }

                    @Override
                    public E next() {
                        if (this.iterator.hasNext()) {
                            return this.iterator.next();
                        }
                        if (!this.elementReturned) {
                            this.elementReturned = true;
                            return element;
                        }
                        throw new NoSuchElementException();
                    }
                };
            }

            @Override
            public int size() {
                return set.size() + 1;
            }
        };
    }

    public static <E1, E2> void forEachPair(Iterable<E1> iterable1, Iterable<E2> iterable2, BiConsumer<E1, E2> action) {
        Iterator<E1> iterator1 = iterable1.iterator();
        Iterator<E2> iterator2 = iterable2.iterator();
        while (iterator1.hasNext() && iterator2.hasNext()) {
            action.accept(iterator1.next(), iterator2.next());
        }
        Preconditions.checkArgument((!iterator1.hasNext() && !iterator2.hasNext() ? 1 : 0) != 0, (Object)"Length mismatch.");
    }

    public static <E> boolean isDistinct(List<E> collection) {
        HashSet<E> set = new HashSet<E>(collection.size());
        for (E element : collection) {
            if (set.add(element)) continue;
            return false;
        }
        return true;
    }

    public static <E> Set<E> ofNullable(@Nullable E element) {
        return element == null ? Set.of() : Set.of(element);
    }

    public static <E> List<E> maximalElements(List<E> elements, BiPredicate<E, E> isLessThan) {
        boolean continueIteration;
        ArrayList maximalElements = new ArrayList(elements.size());
        HashSet seenElements = new HashSet();
        elements.forEach(x -> {
            if (seenElements.add(x)) {
                maximalElements.add(x);
            }
        });
        do {
            continueIteration = false;
            ListIterator iterator = maximalElements.listIterator();
            block1: while (iterator.hasNext()) {
                Object element = iterator.next();
                for (Object otherElement : Iterables.concat(maximalElements.subList(0, iterator.previousIndex()), maximalElements.subList(iterator.nextIndex(), maximalElements.size()))) {
                    if (!isLessThan.test(element, otherElement)) continue;
                    iterator.remove();
                    continueIteration = true;
                    continue block1;
                }
            }
        } while (continueIteration);
        return maximalElements;
    }

    public static <E> List<Set<E>> partition(Collection<E> elements, BiPredicate<E, E> relation) {
        ArrayList partitions = new ArrayList(elements.size());
        elements.forEach(x -> partitions.add(new HashSet<Object>(Set.of(x))));
        boolean continueMerging = true;
        while (continueMerging) {
            continueMerging = false;
            for (int i = 0; i < partitions.size() - 1; ++i) {
                Set partition = (Set)partitions.get(i);
                List<Set> otherPartitions = partitions.subList(i + 1, partitions.size());
                continueMerging |= otherPartitions.removeIf(otherPartition -> {
                    boolean related = partition.stream().anyMatch(x -> otherPartition.stream().anyMatch(y -> x.equals(y) || relation.test(x, y)));
                    if (related) {
                        partition.addAll(otherPartition);
                    }
                    return related;
                });
            }
        }
        return partitions;
    }

    public static <K1, K2> Map<K2, ValuationSet> transformMap(Map<K1, ValuationSet> map, Function<K1, K2> transformer) {
        return Collections3.transformMap(map, transformer, ValuationSet::union);
    }

    public static <K1, K2, V> Map<K2, V> transformMap(Map<K1, V> map, Function<K1, K2> transformer, BiFunction<? super V, ? super V, ? extends V> valueMerger) {
        HashMap transformedMap = new HashMap();
        map.forEach((key, set) -> transformedMap.merge(transformer.apply(key), set, valueMerger));
        if (transformedMap.isEmpty()) {
            return Map.of();
        }
        if (transformedMap.size() == 1) {
            Map.Entry entry = transformedMap.entrySet().iterator().next();
            return Map.of(entry.getKey(), entry.getValue());
        }
        return transformedMap;
    }

    public static <E1, E2> Set<E2> transformSet(Set<E1> set, Function<E1, E2> transformer) {
        HashSet transformedSet = new HashSet();
        set.forEach(x -> transformedSet.add(transformer.apply(x)));
        if (transformedSet.isEmpty()) {
            return Set.of();
        }
        if (transformedSet.size() == 1) {
            return Set.of(transformedSet.iterator().next());
        }
        return transformedSet;
    }

    public static <E> Set<E> union(Set<E> set1, Set<E> set2) {
        if (set1.size() >= set2.size()) {
            set1.addAll(set2);
            return set1;
        }
        set2.addAll(set1);
        return set2;
    }

    public static <E> int compare(Set<? extends E> s1, Set<? extends E> s2) {
        Object[] a1 = (Comparable[])s1.toArray(Comparable[]::new);
        Object[] a2 = (Comparable[])s2.toArray(Comparable[]::new);
        Arrays.sort(a1);
        Arrays.sort(a2);
        return Arrays.compare((Comparable[])a1, (Comparable[])a2);
    }
}

