/*
 * Decompiled with CFR 0.152.
 */
package owl.ltl;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Stream;
import owl.ltl.BooleanConstant;
import owl.ltl.Conjunction;
import owl.ltl.Formula;
import owl.ltl.PropositionalFormula;
import owl.ltl.visitors.BinaryVisitor;
import owl.ltl.visitors.IntVisitor;
import owl.ltl.visitors.Visitor;

public final class Disjunction
extends PropositionalFormula {
    private Disjunction(Formula[] disjuncts) {
        super(Disjunction.class, Set.of(disjuncts));
    }

    public static Formula of(Formula left, Formula right) {
        return Disjunction.of(Arrays.asList(left, right));
    }

    public static Formula of(Formula ... formulas) {
        return Disjunction.of(Arrays.asList(formulas));
    }

    public static Formula of(Iterable<? extends Formula> iterable) {
        return Disjunction.of(iterable.iterator());
    }

    public static Formula of(Stream<? extends Formula> stream) {
        return Disjunction.of(stream.iterator());
    }

    public static Formula of(Iterator<? extends Formula> iterator) {
        HashSet<Formula> set = new HashSet<Formula>();
        while (iterator.hasNext()) {
            Formula child = iterator.next();
            assert (child != null);
            if (BooleanConstant.TRUE.equals(child)) {
                return BooleanConstant.TRUE;
            }
            if (BooleanConstant.FALSE.equals(child)) continue;
            if (child instanceof Disjunction) {
                set.addAll(((Disjunction)child).children);
                continue;
            }
            set.add(child);
        }
        if (set.isEmpty()) {
            return BooleanConstant.FALSE;
        }
        if (set.size() == 1) {
            return (Formula)set.iterator().next();
        }
        return new Disjunction((Formula[])set.toArray(Formula[]::new));
    }

    @Override
    public int accept(IntVisitor v) {
        return v.visit(this);
    }

    @Override
    public <R> R accept(Visitor<R> v) {
        return v.visit(this);
    }

    public <A, B> A accept(BinaryVisitor<B, A> v, B parameter) {
        return v.visit(this, parameter);
    }

    @Override
    public Formula nnf() {
        return Disjunction.of(this.map(Formula::nnf));
    }

    @Override
    public Formula not() {
        return Conjunction.of(this.map(Formula::not));
    }

    @Override
    public Formula substitute(Function<? super Formula.TemporalOperator, ? extends Formula> substitution) {
        return Disjunction.of(this.map(c -> c.substitute(substitution)));
    }

    @Override
    protected String operatorSymbol() {
        return "|";
    }
}

