/*
 * Decompiled with CFR 0.152.
 */
package owl.ltl;

import java.util.function.Function;
import owl.ltl.FOperator;
import owl.ltl.Formula;
import owl.ltl.GOperator;
import owl.ltl.LabelledFormula;
import owl.ltl.ROperator;
import owl.ltl.SyntacticFragment;
import owl.ltl.WOperator;
import owl.ltl.XOperator;
import owl.ltl.visitors.UnabbreviateVisitor;
import owl.ltl.visitors.Visitor;

public final class SyntacticFragments {
    private static final Visitor<Formula> UNABBREVIATE_VISITOR = new UnabbreviateVisitor(WOperator.class, ROperator.class);

    private SyntacticFragments() {
    }

    public static boolean isAlmostAll(Formula formula) {
        return formula instanceof FOperator && ((FOperator)formula).operand instanceof GOperator;
    }

    public static boolean isDetBuchiRecognisable(Formula formula) {
        if (formula instanceof XOperator) {
            return SyntacticFragments.isDetCoBuchiRecognisable(((XOperator)formula).operand);
        }
        return formula instanceof GOperator && SyntacticFragment.CO_SAFETY.contains(((GOperator)formula).operand);
    }

    public static boolean isDetCoBuchiRecognisable(Formula formula) {
        if (formula instanceof XOperator) {
            return SyntacticFragments.isDetBuchiRecognisable(((XOperator)formula).operand);
        }
        return formula instanceof FOperator && SyntacticFragment.SAFETY.contains(((FOperator)formula).operand);
    }

    public static boolean isInfinitelyOften(Formula formula) {
        return formula instanceof GOperator && ((GOperator)formula).operand instanceof FOperator;
    }

    public static boolean isGfCoSafety(Formula formula) {
        if (formula instanceof GOperator) {
            Formula unwrapped = ((GOperator)formula).operand;
            return unwrapped instanceof FOperator && SyntacticFragment.CO_SAFETY.contains(unwrapped);
        }
        return false;
    }

    public static boolean isGCoSafety(Formula formula) {
        if (formula instanceof GOperator) {
            Formula unwrapped = ((GOperator)formula).operand;
            return SyntacticFragment.CO_SAFETY.contains(unwrapped);
        }
        return false;
    }

    public static boolean isFgSafety(Formula formula) {
        if (formula instanceof FOperator) {
            Formula unwrapped = ((FOperator)formula).operand;
            return unwrapped instanceof GOperator && SyntacticFragment.SAFETY.contains(unwrapped);
        }
        return false;
    }

    public static boolean isFSafety(Formula formula) {
        if (formula instanceof FOperator) {
            Formula unwrapped = ((FOperator)formula).operand;
            return SyntacticFragment.SAFETY.contains(unwrapped);
        }
        return false;
    }

    public static boolean isCoSafety(Iterable<? extends Formula> iterable) {
        for (Formula formula : iterable) {
            if (SyntacticFragment.CO_SAFETY.contains(formula)) continue;
            return false;
        }
        return true;
    }

    public static boolean isSafety(Iterable<? extends Formula> iterable) {
        for (Formula formula : iterable) {
            if (SyntacticFragment.SAFETY.contains(formula)) continue;
            return false;
        }
        return true;
    }

    private static Formula normalize(Formula formula, SyntacticFragment fragment, Function<Formula, Formula> normalizer) {
        Formula normalizedFormula = normalizer.apply(formula);
        if (!fragment.contains(normalizedFormula)) {
            throw new IllegalArgumentException("Unsupported formula object found in " + normalizedFormula + ". Supported classes are: " + fragment.classes());
        }
        return normalizedFormula;
    }

    public static Formula normalize(Formula formula, SyntacticFragment fragment) {
        switch (fragment) {
            case ALL: {
                return formula;
            }
            case NNF: {
                return SyntacticFragments.normalize(formula, SyntacticFragment.NNF, Formula::nnf);
            }
            case FGMU: {
                return SyntacticFragments.normalize(formula, SyntacticFragment.FGMU, x -> x.nnf().accept(UNABBREVIATE_VISITOR));
            }
        }
        throw new UnsupportedOperationException();
    }

    public static LabelledFormula normalize(LabelledFormula formula, SyntacticFragment fragment) {
        return formula.wrap(SyntacticFragments.normalize(formula.formula(), fragment));
    }
}

