/*
 * Decompiled with CFR 0.152.
 */
package owl.translations.modules;

import org.apache.commons.cli.CommandLine;
import owl.automaton.acceptance.BuchiAcceptance;
import owl.ltl.LabelledFormula;
import owl.run.modules.InputReaders;
import owl.run.modules.OutputWriters;
import owl.run.modules.OwlModuleParser;
import owl.run.modules.Transformer;
import owl.run.modules.Transformers;
import owl.run.parser.PartialConfigurationParser;
import owl.run.parser.PartialModuleConfiguration;
import owl.translations.ltl2nba.SymmetricNBAConstruction;

public final class LTL2NBAModule
implements OwlModuleParser.TransformerParser {
    public static final LTL2NBAModule INSTANCE = new LTL2NBAModule();

    private LTL2NBAModule() {
    }

    public static void main(String ... args) {
        PartialConfigurationParser.run(args, PartialModuleConfiguration.builder(INSTANCE.getKey()).reader(InputReaders.LTL).addTransformer(Transformers.LTL_SIMPLIFIER).addTransformer(INSTANCE).writer(OutputWriters.HOA).build());
    }

    @Override
    public Transformer parse(CommandLine commandLine) {
        return environment -> Transformers.instanceFromFunction(LabelledFormula.class, SymmetricNBAConstruction.of(environment, BuchiAcceptance.class));
    }

    @Override
    public String getKey() {
        return "ltl2nba";
    }

    @Override
    public String getDescription() {
        return "Translate LTL to non-deterministic generalized-B\u00fcchi automata. The construction is based on the symmetric approach from [EKS: LICS'18].";
    }
}

