/*
 * Decompiled with CFR 0.152.
 */
package jhoafparser.tools;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import jhoafparser.analysis.DeduceAccName;
import jhoafparser.analysis.SyntacticProperties;
import jhoafparser.consumer.HOAConsumer;
import jhoafparser.consumer.HOAConsumerFactory;
import jhoafparser.consumer.HOAConsumerNull;
import jhoafparser.consumer.HOAConsumerPrint;
import jhoafparser.consumer.HOAIntermediateResolveAliases;
import jhoafparser.consumer.HOAIntermediateStoreAndManipulate;
import jhoafparser.consumer.HOAIntermediateTrace;
import jhoafparser.parser.HOAFParser;
import jhoafparser.parser.HOAFParserSettings;
import jhoafparser.parser.generated.ParseException;
import jhoafparser.storage.StoredAutomatonManipulator;
import jhoafparser.transformations.AddProperty;
import jhoafparser.transformations.DNFAcceptance;
import jhoafparser.transformations.ToExplicitLabels;
import jhoafparser.transformations.ToNondetBuchi;
import jhoafparser.transformations.ToStateAcceptance;
import jhoafparser.transformations.ToTransitionAcceptance;

public class JHOAFCmdLine {
    private static final String version = "1.1.1";

    private static HOAConsumerFactory getNullFactory(final PrintStream err) {
        return new HOAConsumerFactory(){

            @Override
            public HOAConsumer getNewHOAConsumer() {
                return new HOAConsumerNull(){

                    @Override
                    public void notifyWarning(String warning) {
                        err.println("Warning: " + warning);
                    }
                };
            }
        };
    }

    public static void main(String[] args) {
        HOAConsumerFactory factory = null;
        InputStream input = null;
        PrintStream errorStream = System.err;
        PrintStream outputStream = System.out;
        Boolean resolveAliases = null;
        Boolean validate = null;
        Boolean trace = null;
        boolean verbose = false;
        ArrayList<String> transformations = new ArrayList<String>();
        ArrayList<String> transformationArguments = new ArrayList<String>();
        HashSet<String> knownTransformations = new HashSet<String>();
        knownTransformations.add("state-acc");
        knownTransformations.add("trans-acc");
        knownTransformations.add("resolve-aliases");
        knownTransformations.add("explicit-labels");
        knownTransformations.add("deduce-accname");
        knownTransformations.add("dnf-acceptance");
        knownTransformations.add("deduce-properties");
        knownTransformations.add("add-property");
        List<String> convertAcceptanceAllowed = null;
        try {
            String flag;
            String command;
            ArrayList<String> arguments = new ArrayList<String>(args.length);
            for (String arg : args) {
                arguments.add(arg);
            }
            String string = command = arguments.size() > 0 ? (String)arguments.remove(0) : null;
            if (command == null || command.equals("help") || command.equals("--help")) {
                JHOAFCmdLine.usage(null);
                System.exit(2);
            }
            if (command.equals("version") || command.equals("--version")) {
                JHOAFCmdLine.printVersion(outputStream, true);
                System.exit(0);
            }
            if (command.equals("convert-acceptance")) {
                String allowedAcceptance;
                String string2 = allowedAcceptance = arguments.size() > 0 ? (String)arguments.remove(0) : null;
                if (allowedAcceptance == null) {
                    JHOAFCmdLine.usage("Command 'convert-acceptance' requires list of acceptance conditions");
                    System.exit(2);
                }
                if ((convertAcceptanceAllowed = Arrays.asList(allowedAcceptance.split(","))).size() == 0) {
                    JHOAFCmdLine.usage("Empty list of allowed acceptance conditions");
                    System.exit(2);
                }
            }
            block56: while (arguments.size() > 0 && ((String)arguments.get(0)).startsWith("--") && !(flag = (String)arguments.remove(0)).equals("--")) {
                switch (flag) {
                    case "--help": {
                        JHOAFCmdLine.usage(null);
                        System.exit(2);
                    }
                    case "--resolve-aliases": {
                        resolveAliases = true;
                        continue block56;
                    }
                    case "--no-validate": {
                        validate = false;
                        continue block56;
                    }
                    case "--trace": {
                        trace = true;
                        continue block56;
                    }
                    case "--verbose": {
                        verbose = true;
                        continue block56;
                    }
                }
                if (flag.startsWith("--transform")) {
                    String[] list;
                    if (!flag.startsWith("--transform=")) {
                        JHOAFCmdLine.usage("Specify transformations via --transform=transformation");
                        System.exit(2);
                    }
                    if ((list = flag.substring("--transform=".length()).split(",")).length == 0) {
                        JHOAFCmdLine.usage("Empty list of transformations: " + flag);
                        System.exit(2);
                    }
                    for (String transformation : list) {
                        String[] t = transformation.split("\\(");
                        String argument = null;
                        if (t.length == 1) {
                            argument = null;
                        } else if (t.length == 2) {
                            argument = t[1];
                            if (!t[1].endsWith(")")) {
                                JHOAFCmdLine.usage("Illegal argument syntax: " + transformation);
                                System.exit(2);
                            }
                            argument = argument.substring(0, argument.length() - 1);
                            transformation = t[0];
                        } else {
                            JHOAFCmdLine.usage("Illegal argument syntax: " + transformation);
                            System.exit(2);
                        }
                        if (knownTransformations.contains(transformation)) {
                            transformations.add(transformation);
                            transformationArguments.add(argument);
                            continue;
                        }
                        JHOAFCmdLine.usage("Unknown transformation: " + transformation + "\n");
                        System.exit(2);
                    }
                    continue;
                }
                JHOAFCmdLine.usage("Unknown/unsupported argument: " + flag);
                System.exit(2);
            }
            if (resolveAliases == null) {
                resolveAliases = false;
            }
            if (validate == null) {
                validate = true;
            }
            if (trace == null) {
                trace = false;
            }
            switch (command) {
                case "print": 
                case "convert-acceptance": 
                case "convert-to-buchi": {
                    factory = HOAConsumerPrint.getFactory(outputStream);
                    if (transformations.size() != 0) {
                        boolean deduceProperties = false;
                        ArrayList<StoredAutomatonManipulator> manipulators = new ArrayList<StoredAutomatonManipulator>();
                        block58: for (int i = 0; i < transformations.size(); ++i) {
                            String transformation = (String)transformations.get(i);
                            String argument = (String)transformationArguments.get(i);
                            switch (transformation) {
                                case "deduce-properties": {
                                    if (argument != null) {
                                        JHOAFCmdLine.usage("Transformation " + transformation + " takes no argument!");
                                        System.exit(2);
                                    }
                                    deduceProperties = true;
                                    continue block58;
                                }
                                case "deduce-accname": {
                                    if (argument != null) {
                                        JHOAFCmdLine.usage("Transformation " + transformation + " takes no argument!");
                                        System.exit(2);
                                    }
                                    factory = DeduceAccName.getFactory(factory);
                                    continue block58;
                                }
                                case "trans-acc": {
                                    if (argument != null) {
                                        JHOAFCmdLine.usage("Transformation " + transformation + " takes no argument!");
                                        System.exit(2);
                                    }
                                    manipulators.add(ToTransitionAcceptance.getStoredAutomatonManipulator());
                                    continue block58;
                                }
                                case "state-acc": {
                                    if (argument != null) {
                                        JHOAFCmdLine.usage("Transformation " + transformation + " takes no argument!");
                                        System.exit(2);
                                    }
                                    manipulators.add(new ToStateAcceptance());
                                    continue block58;
                                }
                                case "explicit-labels": {
                                    if (argument != null) {
                                        JHOAFCmdLine.usage("Transformation " + transformation + " takes no argument!");
                                        System.exit(2);
                                    }
                                    manipulators.add(new ToExplicitLabels(true));
                                    continue block58;
                                }
                                case "dnf-acceptance": {
                                    if (argument != null) {
                                        JHOAFCmdLine.usage("Transformation " + transformation + " takes no argument!");
                                        System.exit(2);
                                    }
                                    factory = DNFAcceptance.getFactory(factory);
                                }
                                case "add-property": {
                                    if (argument == null) {
                                        JHOAFCmdLine.usage("Missing argument for transformation add-property()");
                                        System.exit(2);
                                    }
                                    if (!HOAFParser.isValidIdentifier(argument)) {
                                        JHOAFCmdLine.usage("Property '" + argument + "' for add-property is not a valid HOA identifier.");
                                        System.exit(2);
                                    }
                                    factory = AddProperty.getFactory(factory, argument);
                                    continue block58;
                                }
                                case "resolve-aliases": {
                                    if (argument != null) {
                                        JHOAFCmdLine.usage("Transformation " + transformation + " takes no argument!");
                                        System.exit(2);
                                    }
                                    factory = HOAIntermediateResolveAliases.getFactory(factory);
                                    continue block58;
                                }
                                default: {
                                    JHOAFCmdLine.usage("Unknown transformation: " + transformation);
                                    System.exit(2);
                                }
                            }
                        }
                        if (deduceProperties) {
                            manipulators.add(new SyntacticProperties());
                        }
                        if (manipulators.size() > 0) {
                            factory = HOAIntermediateStoreAndManipulate.getFactory(factory, manipulators.toArray(new StoredAutomatonManipulator[0]));
                        }
                    }
                    if (command.equals("convert-acceptance")) {
                        factory = DeduceAccName.getFactory(factory, convertAcceptanceAllowed);
                        break;
                    }
                    if (!command.equals("convert-to-buchi")) break;
                    factory = HOAIntermediateStoreAndManipulate.getFactory(factory, new ToNondetBuchi());
                    factory = DeduceAccName.getFactory(factory, Arrays.asList("Buchi", "generalized-Buchi"));
                    break;
                }
                case "parse": {
                    errorStream = outputStream;
                    factory = JHOAFCmdLine.getNullFactory(errorStream);
                    break;
                }
                case "add-properties": {
                    factory = HOAIntermediateStoreAndManipulate.getFactory(HOAConsumerPrint.getFactory(outputStream), new SyntacticProperties());
                    break;
                }
                default: {
                    JHOAFCmdLine.usage("Unknown command: " + command);
                    System.exit(2);
                }
            }
            if (resolveAliases.booleanValue()) {
                factory = HOAIntermediateResolveAliases.getFactory(factory);
            }
            if (trace.booleanValue()) {
                factory = HOAIntermediateTrace.getFactory(factory, errorStream);
            }
            if (arguments.isEmpty()) {
                JHOAFCmdLine.usage("Missing filename (or - for standard input)");
                System.exit(2);
            }
            HOAFParserSettings settings = new HOAFParserSettings();
            settings.setFlagValidate(validate);
            for (String filename : arguments) {
                if (filename.equals("-")) {
                    input = System.in;
                    filename = null;
                } else {
                    input = new FileInputStream(filename);
                }
                if (verbose) {
                    errorStream.println("Reading from " + (String)(filename != null ? "file " + filename : "standard input"));
                }
                HOAFParser.parseHOA(input, factory, settings);
            }
            switch (command) {
                case "parse": {
                    outputStream.println("Parsing OK");
                }
            }
        }
        catch (ParseException e) {
            errorStream.println(e);
            System.exit(1);
        }
        catch (FileNotFoundException e) {
            errorStream.println(e);
            System.exit(1);
        }
    }

    private static void printVersion(PrintStream out, boolean verbose) {
        out.println("jhoafparser library - command line tool (version 1.1.1)");
        out.println(" (C) Copyright 2014- Joachim Klein, David Mueller");
        out.println(" http://automata.tools/hoa/jhoafparser/");
        out.println();
        if (verbose) {
            out.println("The jhoafparser library is free software; you can redistribute it and/or");
            out.println("modify it under the terms of the GNU Lesser General Public");
            out.println("License as published by the Free Software Foundation; either");
            out.println("version 2.1 of the License, or (at your option) any later version.");
            out.println();
            out.println("The jhoafparser library is distributed in the hope that it will be useful,");
            out.println("but WITHOUT ANY WARRANTY; without even the implied warranty of");
            out.println("MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU");
            out.println("Lesser General Public License for more details.");
        }
    }

    private static void usage(String error) {
        JHOAFCmdLine.printVersion(System.err, false);
        if (error != null) {
            System.err.println("Command-line arguments error: " + error);
            System.err.println("Use argument 'help' to get usage information.");
            return;
        }
        System.err.println("Arguments:");
        System.err.println("  command [options]* file[s]");
        System.err.println();
        System.err.println(" Valid commands:");
        System.err.println("  parse               Parse the HOAF file and check for errors");
        System.err.println("  print               Parse the HOAF file, perform any specified transformations");
        System.err.println("                        and print the parsed automata to standard out");
        System.err.println("  convert-acceptance <list of acc-names>");
        System.err.println("                      Parse the HOAF file, try to convert to one of the given acceptance");
        System.err.println("                        conditions, print the automaton. The list is given as a comma-seperated");
        System.err.println("                        list conditions, print the automaton. The list is given as a comma-seperated");
        System.err.println("                        list of names that could appear in acc-name headers, e.g., Rabin,Streett");
        System.err.println("  convert-to-buchi");
        System.err.println("                      Parse the HOAF file, apply transformations and convert to a");
        System.err.println("                        non-deterministic Buchi automaton (might be inefficient).");
        System.err.println("                        The original automaton has to be deterministic or non-deterministic");
        System.err.println("  version             Print the version and exit");
        System.err.println("  help                Print this help screen and exit");
        System.err.println();
        System.err.println(" file can be a filename or - to request reading from standard input");
        System.err.println();
        System.err.println(" Valid options:");
        System.err.println("  --transform=<transformations>    Perform transformations (in the given order). Multiple transformations");
        System.err.println("                                   can be specified as a comma-seperated list or using multiple");
        System.err.println("                                   --transform options. See below for a list of supported transformations");
        System.err.println();
        System.err.println("  --resolve-aliases                Resolve aliases");
        System.err.println("  --no-validate                    Disable semantic validation of the automatons");
        System.err.println();
        System.err.println("  --trace                          Debugging: Trace the function calls to HOAConsumer");
        System.err.println("  --verbose                        Increase verbosity");
        System.err.println();
        System.err.println(" Valid transformations:");
        System.err.println("   state-acc                       Transform to state-based acceptance");
        System.err.println("   trans-acc                       Transform to transition-based acceptance");
        System.err.println("   explicit-labels                 Transform to explicit labels");
        System.err.println("   deduce-properties               Deduce properties and add in the header (will always be applied last)");
        System.err.println("   deduce-accname                  Deduce the acc-name");
        System.err.println("   dnf-acceptance                  Transform Acceptance condition into DNF");
        System.err.println("   add-property(p)                 Add property p to the automaton");
        System.err.println("   resolve-aliases                 Resolve all aliases");
    }
}

